/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Module Component</b></em>'.
 * 
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.ModuleComponent#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ModuleComponent#getModule <em>Module</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ModuleComponent#getUri <em>Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ModuleComponent#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getModuleComponent()
 * @model extendedMetaData="name='ModuleComponent' kind='elementOnly'"
 * @generated
 */
public interface ModuleComponent extends Component {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Any</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any</em>' attribute list isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getModuleComponent_Any()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard'
    *        wildcards='##other' name=':3' processing='lax'"
    * @generated
    */
   FeatureMap getAny();

   /**
    * Returns the value of the '<em><b>Module</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Module</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Module</em>' attribute.
    * @see #setModule(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getModuleComponent_Module()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.NCName"
    *        required="true" extendedMetaData="kind='attribute' name='module'"
    * @generated
    */
   String getModule();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.ModuleComponent#getModule <em>Module</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Module</em>' attribute.
    * @see #getModule()
    * @generated
    */
   void setModule(String value);

   /**
    * Returns the value of the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Uri</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Uri</em>' attribute.
    * @see #setUri(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getModuleComponent_Uri()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.AnyURI"
    *        extendedMetaData="kind='attribute' name='uri'"
    * @generated
    */
   String getUri();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.ModuleComponent#getUri <em>Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Uri</em>' attribute.
    * @see #getUri()
    * @generated
    */
   void setUri(String value);

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getModuleComponent_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':6' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

} // ModuleComponent
