/**
 * <copyright> </copyright>
 * 
 * $Id: PropertyValuesSetImpl.java,v 1.2 2006/04/05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.PropertyValue;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Property Values Set</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyValuesSetImpl#getPropertyValues <em>Property Values</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyValuesSetImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class PropertyValuesSetImpl extends SCAInternalObjectImpl implements
      PropertyValuesSet {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright      = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getPropertyValues() <em>Property Values</em>}'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getPropertyValues()
    * @generated
    * @ordered
    */
   protected EList            propertyValues = null;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap       anyAttribute   = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected PropertyValuesSetImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getPropertyValuesSet();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getPropertyValues() {
      if (propertyValues == null) {
         propertyValues = new EObjectContainmentEList(PropertyValue.class,
               this, SCAPackage.PROPERTY_VALUES_SET__PROPERTY_VALUES);
      }
      return propertyValues;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.PROPERTY_VALUES_SET__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.PROPERTY_VALUES_SET__PROPERTY_VALUES:
               return ((InternalEList) getPropertyValues()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.PROPERTY_VALUES_SET__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.PROPERTY_VALUES_SET__PROPERTY_VALUES:
            return getPropertyValues();
         case SCAPackage.PROPERTY_VALUES_SET__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.PROPERTY_VALUES_SET__PROPERTY_VALUES:
            getPropertyValues().clear();
            getPropertyValues().addAll((Collection) newValue);
            return;
         case SCAPackage.PROPERTY_VALUES_SET__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.PROPERTY_VALUES_SET__PROPERTY_VALUES:
            getPropertyValues().clear();
            return;
         case SCAPackage.PROPERTY_VALUES_SET__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.PROPERTY_VALUES_SET__PROPERTY_VALUES:
            return propertyValues != null && !propertyValues.isEmpty();
         case SCAPackage.PROPERTY_VALUES_SET__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

} // PropertyValuesSetImpl
