/**
 * <copyright> </copyright>
 * 
 * $Id: SCAPackageImpl.java,v 1.1 2006/03/31 21:58:48 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.impl.XMLTypePackageImpl;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Binding;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.ModuleComponent;
import org.eclipse.stp.core.sca.ModuleFragment;
import org.eclipse.stp.core.sca.ModuleReference;
import org.eclipse.stp.core.sca.ModuleService;
import org.eclipse.stp.core.sca.ModuleWire;
import org.eclipse.stp.core.sca.OverrideOptions;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.PropertyValue;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCABinding;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.SLSBBinding;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.Subsystem;
import org.eclipse.stp.core.sca.SystemWire;
import org.eclipse.stp.core.sca.UnknownImplementation;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.stp.core.sca.WebServiceBinding;
import org.eclipse.stp.core.sca.util.SCAValidator;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class SCAPackageImpl extends EPackageImpl implements SCAPackage {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright                      = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             abstractImplementationEClass   = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             bindingEClass                  = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             componentEClass                = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             componentTypeEClass            = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             compositeEClass                = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             entryPointEClass               = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             externalServiceEClass          = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             implementationEClass           = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             implementationComponentEClass  = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             interfaceEClass                = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             javaImplementationEClass       = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             javaInterfaceEClass            = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             moduleEClass                   = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             moduleComponentEClass          = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             moduleFragmentEClass           = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             moduleReferenceEClass          = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             moduleServiceEClass            = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             moduleWireEClass               = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             propertyEClass                 = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             propertyValueEClass            = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             propertyValuesSetEClass        = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             referenceEClass                = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             referenceValueEClass           = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             referenceValuesSetEClass       = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             scaBindingEClass               = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             scaCoreRootEClass              = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             serviceEClass                  = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             slsbBindingEClass              = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             subsystemEClass                = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             systemWireEClass               = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             unknownImplementationEClass    = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             webServiceBindingEClass        = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EClass             wsdlPortTypeEClass             = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EEnum              overrideOptionsEEnum           = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EDataType          multiplicityEDataType          = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private EDataType          overrideOptionsObjectEDataType = null;

   /**
    * Creates an instance of the model <b>Package</b>, registered with
    * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
    * package package URI value.
    * <p>
    * Note: the correct way to create the package is via the static factory
    * method {@link #init init()}, which also performs initialization of the
    * package, or returns the registered package, if one already exists. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.emf.ecore.EPackage.Registry
    * @see org.eclipse.stp.core.sca.SCAPackage#eNS_URI
    * @see #init()
    * @generated
    */
   private SCAPackageImpl() {
      super(eNS_URI, SCAFactory.eINSTANCE);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private static boolean isInited = false;

   /**
    * Creates, registers, and initializes the <b>Package</b> for this model,
    * and for any others upon which it depends. Simple dependencies are
    * satisfied by calling this method on all dependent packages before doing
    * anything else. This method drives initialization for interdependent
    * packages directly, in parallel with this package, itself.
    * <p>
    * Of this package and its interdependencies, all packages which have not yet
    * been registered by their URI values are first created and registered. The
    * packages are then initialized in two steps: meta-model objects for all of
    * the packages are created before any are initialized, since one package's
    * meta-model objects may refer to those of another.
    * <p>
    * Invocation of this method will not affect any packages that have already
    * been initialized. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #eNS_URI
    * @see #createPackageContents()
    * @see #initializePackageContents()
    * @generated
    */
   public static SCAPackage init() {
      if (isInited)
         return (SCAPackage) EPackage.Registry.INSTANCE
               .getEPackage(SCAPackage.eNS_URI);

      // Obtain or create and register package
      SCAPackageImpl theSCAPackage = (SCAPackageImpl) (EPackage.Registry.INSTANCE
            .getEPackage(eNS_URI) instanceof SCAPackageImpl ? EPackage.Registry.INSTANCE
            .getEPackage(eNS_URI)
            : new SCAPackageImpl());

      isInited = true;

      // Initialize simple dependencies
      XMLTypePackageImpl.init();

      // Create package meta-data objects
      theSCAPackage.createPackageContents();

      // Initialize created meta-data
      theSCAPackage.initializePackageContents();

      // Register package validator
      EValidator.Registry.INSTANCE.put(theSCAPackage,
            new EValidator.Descriptor() {
               public EValidator getEValidator() {
                  return SCAValidator.INSTANCE;
               }
            });

      // Mark meta-data to indicate it can't be changed
      theSCAPackage.freeze();

      return theSCAPackage;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getAbstractImplementation() {
      return abstractImplementationEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getAbstractImplementation_ComponentType() {
      return (EReference) abstractImplementationEClass.getEStructuralFeatures()
            .get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getAbstractImplementation_Type() {
      return (EAttribute) abstractImplementationEClass.getEStructuralFeatures()
            .get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getBinding() {
      return bindingEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getBinding_Uri() {
      return (EAttribute) bindingEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getComponent() {
      return componentEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getComponent_PropertyValuesSet() {
      return (EReference) componentEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getComponent_ReferenceValuesSet() {
      return (EReference) componentEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getComponent_Name() {
      return (EAttribute) componentEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getComponentType() {
      return componentTypeEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getComponentType_Services() {
      return (EReference) componentTypeEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getComponentType_References() {
      return (EReference) componentTypeEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getComponentType_Properties() {
      return (EReference) componentTypeEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getComponentType_Any() {
      return (EAttribute) componentTypeEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getComponentType_AnyAttribute() {
      return (EAttribute) componentTypeEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getComposite() {
      return compositeEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getComposite_EntryPoints() {
      return (EReference) compositeEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getComposite_ComponentsGroup() {
      return (EAttribute) compositeEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getComposite_ExternalServices() {
      return (EReference) compositeEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getComposite_Components() {
      return (EReference) compositeEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getComposite_Name() {
      return (EAttribute) compositeEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getEntryPoint() {
      return entryPointEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getEntryPoint_InterfaceGroup() {
      return (EAttribute) entryPointEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getEntryPoint_Interface() {
      return (EReference) entryPointEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getEntryPoint_BindingGroup() {
      return (EAttribute) entryPointEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getEntryPoint_Bindings() {
      return (EReference) entryPointEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getEntryPoint_ReferenceTargets() {
      return (EAttribute) entryPointEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getEntryPoint_Any() {
      return (EAttribute) entryPointEClass.getEStructuralFeatures().get(5);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getEntryPoint_Multiplicity() {
      return (EAttribute) entryPointEClass.getEStructuralFeatures().get(6);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getEntryPoint_Name() {
      return (EAttribute) entryPointEClass.getEStructuralFeatures().get(7);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getEntryPoint_AnyAttribute() {
      return (EAttribute) entryPointEClass.getEStructuralFeatures().get(8);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getExternalService() {
      return externalServiceEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getExternalService_Interface() {
      return (EReference) externalServiceEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getExternalService_BindingGroup() {
      return (EAttribute) externalServiceEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getExternalService_Bindings() {
      return (EReference) externalServiceEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getExternalService_InterfaceGroup() {
      return (EAttribute) externalServiceEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getExternalService_Any() {
      return (EAttribute) externalServiceEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getExternalService_Name() {
      return (EAttribute) externalServiceEClass.getEStructuralFeatures().get(5);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getExternalService_Overridable() {
      return (EAttribute) externalServiceEClass.getEStructuralFeatures().get(6);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getExternalService_AnyAttribute() {
      return (EAttribute) externalServiceEClass.getEStructuralFeatures().get(7);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getImplementation() {
      return implementationEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getImplementationComponent() {
      return implementationComponentEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getImplementationComponent_ImplementationGroup() {
      return (EAttribute) implementationComponentEClass
            .getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getImplementationComponent_Implementation() {
      return (EReference) implementationComponentEClass
            .getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getImplementationComponent_Any() {
      return (EAttribute) implementationComponentEClass
            .getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getImplementationComponent_AnyAttribute() {
      return (EAttribute) implementationComponentEClass
            .getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getInterface() {
      return interfaceEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getJavaImplementation() {
      return javaImplementationEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getJavaImplementation_Any() {
      return (EAttribute) javaImplementationEClass.getEStructuralFeatures()
            .get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getJavaImplementation_Class() {
      return (EAttribute) javaImplementationEClass.getEStructuralFeatures()
            .get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getJavaImplementation_AnyAttribute() {
      return (EAttribute) javaImplementationEClass.getEStructuralFeatures()
            .get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getJavaInterface() {
      return javaInterfaceEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getJavaInterface_Any() {
      return (EAttribute) javaInterfaceEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getJavaInterface_CallbackInterface() {
      return (EAttribute) javaInterfaceEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getJavaInterface_Interface() {
      return (EAttribute) javaInterfaceEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getJavaInterface_AnyAttribute() {
      return (EAttribute) javaInterfaceEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getModule() {
      return moduleEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getModuleComponent() {
      return moduleComponentEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleComponent_Any() {
      return (EAttribute) moduleComponentEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleComponent_Module() {
      return (EAttribute) moduleComponentEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleComponent_Uri() {
      return (EAttribute) moduleComponentEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleComponent_AnyAttribute() {
      return (EAttribute) moduleComponentEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getModuleFragment() {
      return moduleFragmentEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getModuleFragment_Wires() {
      return (EReference) moduleFragmentEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleFragment_Any() {
      return (EAttribute) moduleFragmentEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleFragment_AnyAttribute() {
      return (EAttribute) moduleFragmentEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getModuleReference() {
      return moduleReferenceEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getModuleReference_ExternalService() {
      return (EReference) moduleReferenceEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getModuleService() {
      return moduleServiceEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getModuleService_EntryPoint() {
      return (EReference) moduleServiceEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getModuleWire() {
      return moduleWireEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleWire_SourceUri() {
      return (EAttribute) moduleWireEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleWire_TargetUri() {
      return (EAttribute) moduleWireEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleWire_Any() {
      return (EAttribute) moduleWireEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getModuleWire_AnyAttribute() {
      return (EAttribute) moduleWireEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getProperty() {
      return propertyEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getProperty_Any() {
      return (EAttribute) propertyEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getProperty_Default() {
      return (EAttribute) propertyEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getProperty_Many() {
      return (EAttribute) propertyEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getProperty_Name() {
      return (EAttribute) propertyEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getProperty_Required() {
      return (EAttribute) propertyEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getProperty_Type() {
      return (EAttribute) propertyEClass.getEStructuralFeatures().get(5);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getProperty_AnyAttribute() {
      return (EAttribute) propertyEClass.getEStructuralFeatures().get(6);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getPropertyValue() {
      return propertyValueEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getPropertyValue_Value() {
      return (EAttribute) propertyValueEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getPropertyValue_Name() {
      return (EAttribute) propertyValueEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getPropertyValuesSet() {
      return propertyValuesSetEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getPropertyValuesSet_PropertyValues() {
      return (EReference) propertyValuesSetEClass.getEStructuralFeatures().get(
            0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getPropertyValuesSet_AnyAttribute() {
      return (EAttribute) propertyValuesSetEClass.getEStructuralFeatures().get(
            1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getReference() {
      return referenceEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReference_InterfaceGroup() {
      return (EAttribute) referenceEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getReference_Interface() {
      return (EReference) referenceEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReference_Any() {
      return (EAttribute) referenceEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReference_Multiplicity() {
      return (EAttribute) referenceEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReference_Name() {
      return (EAttribute) referenceEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReference_AnyAttribute() {
      return (EAttribute) referenceEClass.getEStructuralFeatures().get(5);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getReferenceValue() {
      return referenceValueEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReferenceValue_TargetURI() {
      return (EAttribute) referenceValueEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReferenceValue_Name() {
      return (EAttribute) referenceValueEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReferenceValue_AnyAttribute() {
      return (EAttribute) referenceValueEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getReferenceValue_ReferenceValueSet() {
      return (EReference) referenceValueEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getReferenceValuesSet() {
      return referenceValuesSetEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getReferenceValuesSet_ReferenceValues() {
      return (EReference) referenceValuesSetEClass.getEStructuralFeatures()
            .get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getReferenceValuesSet_AnyAttribute() {
      return (EAttribute) referenceValuesSetEClass.getEStructuralFeatures()
            .get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getReferenceValuesSet_Component() {
      return (EReference) referenceValuesSetEClass.getEStructuralFeatures()
            .get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getSCABinding() {
      return scaBindingEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSCABinding_Any() {
      return (EAttribute) scaBindingEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSCABinding_AnyAttribute() {
      return (EAttribute) scaBindingEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getSCACoreRoot() {
      return scaCoreRootEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSCACoreRoot_Mixed() {
      return (EAttribute) scaCoreRootEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_XMLNSPrefixMap() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_XSISchemaLocation() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_AbstractComponent() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Binding() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_BindingSca() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(5);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Component() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(6);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_ComponentType() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(7);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Composite() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(8);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Implementation() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(9);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_ImplementationAbstract() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(10);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_ImplementationUnknown() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(11);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Interface() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(12);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Module() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(13);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_ModuleComponent() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(14);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_ModuleFragment() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(15);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Source() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(16);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_SourceEpr() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(17);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSCACoreRoot_SourceUri() {
      return (EAttribute) scaCoreRootEClass.getEStructuralFeatures().get(18);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Subsystem() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(19);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_Target() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(20);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_TargetEpr() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(21);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSCACoreRoot_TargetUri() {
      return (EAttribute) scaCoreRootEClass.getEStructuralFeatures().get(22);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_InterfaceWsdl() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(23);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_InterfaceJava() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(24);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_BindingWs() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(25);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_ImplementationJava() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(26);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSCACoreRoot_BindingEjb() {
      return (EReference) scaCoreRootEClass.getEStructuralFeatures().get(27);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getService() {
      return serviceEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getService_InterfaceGroup() {
      return (EAttribute) serviceEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getService_Interface() {
      return (EReference) serviceEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getService_Any() {
      return (EAttribute) serviceEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getService_Name() {
      return (EAttribute) serviceEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getService_AnyAttribute() {
      return (EAttribute) serviceEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getSLSBBinding() {
      return slsbBindingEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSLSBBinding_JndiName() {
      return (EAttribute) slsbBindingEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getSubsystem() {
      return subsystemEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSubsystem_Wires() {
      return (EReference) subsystemEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSubsystem_Any() {
      return (EAttribute) subsystemEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSubsystem_Uri() {
      return (EAttribute) subsystemEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSubsystem_AnyAttribute() {
      return (EAttribute) subsystemEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getSystemWire() {
      return systemWireEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSystemWire_SourceGroup() {
      return (EAttribute) systemWireEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSystemWire_Source() {
      return (EReference) systemWireEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSystemWire_TargetGroup() {
      return (EAttribute) systemWireEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EReference getSystemWire_Target() {
      return (EReference) systemWireEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getSystemWire_Any() {
      return (EAttribute) systemWireEClass.getEStructuralFeatures().get(4);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getUnknownImplementation() {
      return unknownImplementationEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getUnknownImplementation_Uri() {
      return (EAttribute) unknownImplementationEClass.getEStructuralFeatures()
            .get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getWebServiceBinding() {
      return webServiceBindingEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getWebServiceBinding_Any() {
      return (EAttribute) webServiceBindingEClass.getEStructuralFeatures().get(
            0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getWebServiceBinding_Port() {
      return (EAttribute) webServiceBindingEClass.getEStructuralFeatures().get(
            1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getWebServiceBinding_AnyAttribute() {
      return (EAttribute) webServiceBindingEClass.getEStructuralFeatures().get(
            2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EClass getWSDLPortType() {
      return wsdlPortTypeEClass;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getWSDLPortType_Any() {
      return (EAttribute) wsdlPortTypeEClass.getEStructuralFeatures().get(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getWSDLPortType_CallbackInterface() {
      return (EAttribute) wsdlPortTypeEClass.getEStructuralFeatures().get(1);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getWSDLPortType_Interface() {
      return (EAttribute) wsdlPortTypeEClass.getEStructuralFeatures().get(2);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EAttribute getWSDLPortType_AnyAttribute() {
      return (EAttribute) wsdlPortTypeEClass.getEStructuralFeatures().get(3);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EEnum getOverrideOptions() {
      return overrideOptionsEEnum;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EDataType getMultiplicity() {
      return multiplicityEDataType;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EDataType getOverrideOptionsObject() {
      return overrideOptionsObjectEDataType;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SCAFactory getSCAFactory() {
      return (SCAFactory) getEFactoryInstance();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private boolean isCreated = false;

   /**
    * Creates the meta-model objects for the package. This method is guarded to
    * have no affect on any invocation but its first. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public void createPackageContents() {
      if (isCreated)
         return;
      isCreated = true;

      // Create classes and their features
      abstractImplementationEClass = createEClass(ABSTRACT_IMPLEMENTATION);
      createEReference(abstractImplementationEClass,
            ABSTRACT_IMPLEMENTATION__COMPONENT_TYPE);
      createEAttribute(abstractImplementationEClass,
            ABSTRACT_IMPLEMENTATION__TYPE);

      bindingEClass = createEClass(BINDING);
      createEAttribute(bindingEClass, BINDING__URI);

      componentEClass = createEClass(COMPONENT);
      createEReference(componentEClass, COMPONENT__PROPERTY_VALUES_SET);
      createEReference(componentEClass, COMPONENT__REFERENCE_VALUES_SET);
      createEAttribute(componentEClass, COMPONENT__NAME);

      componentTypeEClass = createEClass(COMPONENT_TYPE);
      createEReference(componentTypeEClass, COMPONENT_TYPE__SERVICES);
      createEReference(componentTypeEClass, COMPONENT_TYPE__REFERENCES);
      createEReference(componentTypeEClass, COMPONENT_TYPE__PROPERTIES);
      createEAttribute(componentTypeEClass, COMPONENT_TYPE__ANY);
      createEAttribute(componentTypeEClass, COMPONENT_TYPE__ANY_ATTRIBUTE);

      compositeEClass = createEClass(COMPOSITE);
      createEReference(compositeEClass, COMPOSITE__ENTRY_POINTS);
      createEAttribute(compositeEClass, COMPOSITE__COMPONENTS_GROUP);
      createEReference(compositeEClass, COMPOSITE__COMPONENTS);
      createEReference(compositeEClass, COMPOSITE__EXTERNAL_SERVICES);
      createEAttribute(compositeEClass, COMPOSITE__NAME);

      entryPointEClass = createEClass(ENTRY_POINT);
      createEAttribute(entryPointEClass, ENTRY_POINT__INTERFACE_GROUP);
      createEReference(entryPointEClass, ENTRY_POINT__INTERFACE);
      createEAttribute(entryPointEClass, ENTRY_POINT__BINDING_GROUP);
      createEReference(entryPointEClass, ENTRY_POINT__BINDINGS);
      createEAttribute(entryPointEClass, ENTRY_POINT__REFERENCE_TARGETS);
      createEAttribute(entryPointEClass, ENTRY_POINT__ANY);
      createEAttribute(entryPointEClass, ENTRY_POINT__MULTIPLICITY);
      createEAttribute(entryPointEClass, ENTRY_POINT__NAME);
      createEAttribute(entryPointEClass, ENTRY_POINT__ANY_ATTRIBUTE);

      externalServiceEClass = createEClass(EXTERNAL_SERVICE);
      createEAttribute(externalServiceEClass, EXTERNAL_SERVICE__BINDING_GROUP);
      createEReference(externalServiceEClass, EXTERNAL_SERVICE__BINDINGS);
      createEAttribute(externalServiceEClass, EXTERNAL_SERVICE__INTERFACE_GROUP);
      createEReference(externalServiceEClass, EXTERNAL_SERVICE__INTERFACE);
      createEAttribute(externalServiceEClass, EXTERNAL_SERVICE__ANY);
      createEAttribute(externalServiceEClass, EXTERNAL_SERVICE__NAME);
      createEAttribute(externalServiceEClass, EXTERNAL_SERVICE__OVERRIDABLE);
      createEAttribute(externalServiceEClass, EXTERNAL_SERVICE__ANY_ATTRIBUTE);

      implementationEClass = createEClass(IMPLEMENTATION);

      implementationComponentEClass = createEClass(IMPLEMENTATION_COMPONENT);
      createEAttribute(implementationComponentEClass,
            IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP);
      createEReference(implementationComponentEClass,
            IMPLEMENTATION_COMPONENT__IMPLEMENTATION);
      createEAttribute(implementationComponentEClass,
            IMPLEMENTATION_COMPONENT__ANY);
      createEAttribute(implementationComponentEClass,
            IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE);

      interfaceEClass = createEClass(INTERFACE);

      javaImplementationEClass = createEClass(JAVA_IMPLEMENTATION);
      createEAttribute(javaImplementationEClass, JAVA_IMPLEMENTATION__ANY);
      createEAttribute(javaImplementationEClass, JAVA_IMPLEMENTATION__CLASS);
      createEAttribute(javaImplementationEClass,
            JAVA_IMPLEMENTATION__ANY_ATTRIBUTE);

      javaInterfaceEClass = createEClass(JAVA_INTERFACE);
      createEAttribute(javaInterfaceEClass, JAVA_INTERFACE__ANY);
      createEAttribute(javaInterfaceEClass, JAVA_INTERFACE__CALLBACK_INTERFACE);
      createEAttribute(javaInterfaceEClass, JAVA_INTERFACE__INTERFACE);
      createEAttribute(javaInterfaceEClass, JAVA_INTERFACE__ANY_ATTRIBUTE);

      moduleEClass = createEClass(MODULE);

      moduleComponentEClass = createEClass(MODULE_COMPONENT);
      createEAttribute(moduleComponentEClass, MODULE_COMPONENT__ANY);
      createEAttribute(moduleComponentEClass, MODULE_COMPONENT__MODULE);
      createEAttribute(moduleComponentEClass, MODULE_COMPONENT__URI);
      createEAttribute(moduleComponentEClass, MODULE_COMPONENT__ANY_ATTRIBUTE);

      moduleFragmentEClass = createEClass(MODULE_FRAGMENT);
      createEReference(moduleFragmentEClass, MODULE_FRAGMENT__WIRES);
      createEAttribute(moduleFragmentEClass, MODULE_FRAGMENT__ANY);
      createEAttribute(moduleFragmentEClass, MODULE_FRAGMENT__ANY_ATTRIBUTE);

      moduleReferenceEClass = createEClass(MODULE_REFERENCE);
      createEReference(moduleReferenceEClass,
            MODULE_REFERENCE__EXTERNAL_SERVICE);

      moduleServiceEClass = createEClass(MODULE_SERVICE);
      createEReference(moduleServiceEClass, MODULE_SERVICE__ENTRY_POINT);

      moduleWireEClass = createEClass(MODULE_WIRE);
      createEAttribute(moduleWireEClass, MODULE_WIRE__SOURCE_URI);
      createEAttribute(moduleWireEClass, MODULE_WIRE__TARGET_URI);
      createEAttribute(moduleWireEClass, MODULE_WIRE__ANY);
      createEAttribute(moduleWireEClass, MODULE_WIRE__ANY_ATTRIBUTE);

      propertyEClass = createEClass(PROPERTY);
      createEAttribute(propertyEClass, PROPERTY__ANY);
      createEAttribute(propertyEClass, PROPERTY__DEFAULT);
      createEAttribute(propertyEClass, PROPERTY__MANY);
      createEAttribute(propertyEClass, PROPERTY__NAME);
      createEAttribute(propertyEClass, PROPERTY__REQUIRED);
      createEAttribute(propertyEClass, PROPERTY__TYPE);
      createEAttribute(propertyEClass, PROPERTY__ANY_ATTRIBUTE);

      propertyValueEClass = createEClass(PROPERTY_VALUE);
      createEAttribute(propertyValueEClass, PROPERTY_VALUE__VALUE);
      createEAttribute(propertyValueEClass, PROPERTY_VALUE__NAME);

      propertyValuesSetEClass = createEClass(PROPERTY_VALUES_SET);
      createEReference(propertyValuesSetEClass,
            PROPERTY_VALUES_SET__PROPERTY_VALUES);
      createEAttribute(propertyValuesSetEClass,
            PROPERTY_VALUES_SET__ANY_ATTRIBUTE);

      referenceEClass = createEClass(REFERENCE);
      createEAttribute(referenceEClass, REFERENCE__INTERFACE_GROUP);
      createEReference(referenceEClass, REFERENCE__INTERFACE);
      createEAttribute(referenceEClass, REFERENCE__ANY);
      createEAttribute(referenceEClass, REFERENCE__MULTIPLICITY);
      createEAttribute(referenceEClass, REFERENCE__NAME);
      createEAttribute(referenceEClass, REFERENCE__ANY_ATTRIBUTE);

      referenceValueEClass = createEClass(REFERENCE_VALUE);
      createEAttribute(referenceValueEClass, REFERENCE_VALUE__TARGET_URI);
      createEAttribute(referenceValueEClass, REFERENCE_VALUE__NAME);
      createEAttribute(referenceValueEClass, REFERENCE_VALUE__ANY_ATTRIBUTE);
      createEReference(referenceValueEClass,
            REFERENCE_VALUE__REFERENCE_VALUE_SET);

      referenceValuesSetEClass = createEClass(REFERENCE_VALUES_SET);
      createEReference(referenceValuesSetEClass,
            REFERENCE_VALUES_SET__REFERENCE_VALUES);
      createEAttribute(referenceValuesSetEClass,
            REFERENCE_VALUES_SET__ANY_ATTRIBUTE);
      createEReference(referenceValuesSetEClass,
            REFERENCE_VALUES_SET__COMPONENT);

      scaBindingEClass = createEClass(SCA_BINDING);
      createEAttribute(scaBindingEClass, SCA_BINDING__ANY);
      createEAttribute(scaBindingEClass, SCA_BINDING__ANY_ATTRIBUTE);

      scaCoreRootEClass = createEClass(SCA_CORE_ROOT);
      createEAttribute(scaCoreRootEClass, SCA_CORE_ROOT__MIXED);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__XMLNS_PREFIX_MAP);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__XSI_SCHEMA_LOCATION);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__ABSTRACT_COMPONENT);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__BINDING);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__BINDING_SCA);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__COMPONENT);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__COMPONENT_TYPE);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__COMPOSITE);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__IMPLEMENTATION);
      createEReference(scaCoreRootEClass,
            SCA_CORE_ROOT__IMPLEMENTATION_ABSTRACT);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__IMPLEMENTATION_UNKNOWN);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__INTERFACE);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__MODULE);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__MODULE_COMPONENT);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__MODULE_FRAGMENT);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__SOURCE);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__SOURCE_EPR);
      createEAttribute(scaCoreRootEClass, SCA_CORE_ROOT__SOURCE_URI);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__SUBSYSTEM);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__TARGET);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__TARGET_EPR);
      createEAttribute(scaCoreRootEClass, SCA_CORE_ROOT__TARGET_URI);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__INTERFACE_WSDL);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__INTERFACE_JAVA);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__BINDING_WS);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__IMPLEMENTATION_JAVA);
      createEReference(scaCoreRootEClass, SCA_CORE_ROOT__BINDING_EJB);

      serviceEClass = createEClass(SERVICE);
      createEAttribute(serviceEClass, SERVICE__INTERFACE_GROUP);
      createEReference(serviceEClass, SERVICE__INTERFACE);
      createEAttribute(serviceEClass, SERVICE__ANY);
      createEAttribute(serviceEClass, SERVICE__NAME);
      createEAttribute(serviceEClass, SERVICE__ANY_ATTRIBUTE);

      slsbBindingEClass = createEClass(SLSB_BINDING);
      createEAttribute(slsbBindingEClass, SLSB_BINDING__JNDI_NAME);

      subsystemEClass = createEClass(SUBSYSTEM);
      createEReference(subsystemEClass, SUBSYSTEM__WIRES);
      createEAttribute(subsystemEClass, SUBSYSTEM__ANY);
      createEAttribute(subsystemEClass, SUBSYSTEM__URI);
      createEAttribute(subsystemEClass, SUBSYSTEM__ANY_ATTRIBUTE);

      systemWireEClass = createEClass(SYSTEM_WIRE);
      createEAttribute(systemWireEClass, SYSTEM_WIRE__SOURCE_GROUP);
      createEReference(systemWireEClass, SYSTEM_WIRE__SOURCE);
      createEAttribute(systemWireEClass, SYSTEM_WIRE__TARGET_GROUP);
      createEReference(systemWireEClass, SYSTEM_WIRE__TARGET);
      createEAttribute(systemWireEClass, SYSTEM_WIRE__ANY);

      unknownImplementationEClass = createEClass(UNKNOWN_IMPLEMENTATION);
      createEAttribute(unknownImplementationEClass, UNKNOWN_IMPLEMENTATION__URI);

      webServiceBindingEClass = createEClass(WEB_SERVICE_BINDING);
      createEAttribute(webServiceBindingEClass, WEB_SERVICE_BINDING__ANY);
      createEAttribute(webServiceBindingEClass, WEB_SERVICE_BINDING__PORT);
      createEAttribute(webServiceBindingEClass,
            WEB_SERVICE_BINDING__ANY_ATTRIBUTE);

      wsdlPortTypeEClass = createEClass(WSDL_PORT_TYPE);
      createEAttribute(wsdlPortTypeEClass, WSDL_PORT_TYPE__ANY);
      createEAttribute(wsdlPortTypeEClass, WSDL_PORT_TYPE__CALLBACK_INTERFACE);
      createEAttribute(wsdlPortTypeEClass, WSDL_PORT_TYPE__INTERFACE);
      createEAttribute(wsdlPortTypeEClass, WSDL_PORT_TYPE__ANY_ATTRIBUTE);

      // Create enums
      overrideOptionsEEnum = createEEnum(OVERRIDE_OPTIONS);

      // Create data types
      multiplicityEDataType = createEDataType(MULTIPLICITY);
      overrideOptionsObjectEDataType = createEDataType(OVERRIDE_OPTIONS_OBJECT);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private boolean isInitialized = false;

   /**
    * Complete the initialization of the package and its meta-model. This method
    * is guarded to have no affect on any invocation but its first. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void initializePackageContents() {
      if (isInitialized)
         return;
      isInitialized = true;

      // Initialize package
      setName(eNAME);
      setNsPrefix(eNS_PREFIX);
      setNsURI(eNS_URI);

      // Obtain other dependent packages
      XMLTypePackageImpl theXMLTypePackage = (XMLTypePackageImpl) EPackage.Registry.INSTANCE
            .getEPackage(XMLTypePackage.eNS_URI);

      // Add supertypes to classes
      abstractImplementationEClass.getESuperTypes().add(
            this.getImplementation());
      implementationComponentEClass.getESuperTypes().add(this.getComponent());
      javaImplementationEClass.getESuperTypes().add(this.getImplementation());
      javaInterfaceEClass.getESuperTypes().add(this.getInterface());
      moduleEClass.getESuperTypes().add(this.getModuleFragment());
      moduleComponentEClass.getESuperTypes().add(this.getComponent());
      moduleFragmentEClass.getESuperTypes().add(this.getComposite());
      moduleReferenceEClass.getESuperTypes().add(this.getReference());
      moduleServiceEClass.getESuperTypes().add(this.getService());
      scaBindingEClass.getESuperTypes().add(this.getBinding());
      slsbBindingEClass.getESuperTypes().add(this.getBinding());
      subsystemEClass.getESuperTypes().add(this.getComposite());
      unknownImplementationEClass.getESuperTypes()
            .add(this.getImplementation());
      webServiceBindingEClass.getESuperTypes().add(this.getBinding());
      wsdlPortTypeEClass.getESuperTypes().add(this.getInterface());

      // Initialize classes and features; add operations and parameters
      initEClass(
            abstractImplementationEClass,
            AbstractImplementation.class,
            "AbstractImplementation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getAbstractImplementation_ComponentType(),
            this.getComponentType(),
            null,
            "componentType", null, 1, 1, AbstractImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getAbstractImplementation_Type(),
            theXMLTypePackage.getNCName(),
            "type", null, 0, 1, AbstractImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(bindingEClass, Binding.class,
            "Binding", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getBinding_Uri(),
            theXMLTypePackage.getAnyURI(),
            "uri", null, 0, 1, Binding.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            componentEClass,
            Component.class,
            "Component", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getComponent_PropertyValuesSet(),
            this.getPropertyValuesSet(),
            null,
            "propertyValuesSet", null, 0, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getComponent_ReferenceValuesSet(),
            this.getReferenceValuesSet(),
            this.getReferenceValuesSet_Component(),
            "referenceValuesSet", null, 0, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getComponent_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            componentTypeEClass,
            ComponentType.class,
            "ComponentType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getComponentType_Services(),
            this.getService(),
            null,
            "services", null, 0, -1, ComponentType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getComponentType_References(),
            this.getReference(),
            null,
            "references", null, 0, -1, ComponentType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getComponentType_Properties(),
            this.getProperty(),
            null,
            "properties", null, 0, -1, ComponentType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getComponentType_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, ComponentType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getComponentType_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, ComponentType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            compositeEClass,
            Composite.class,
            "Composite", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getComposite_EntryPoints(),
            this.getEntryPoint(),
            null,
            "entryPoints", null, 0, -1, Composite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getComposite_ComponentsGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "componentsGroup", null, 0, -1, Composite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getComposite_Components(),
            this.getComponent(),
            null,
            "components", null, 0, -1, Composite.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getComposite_ExternalServices(),
            this.getExternalService(),
            null,
            "externalServices", null, 0, -1, Composite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getComposite_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, Composite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            entryPointEClass,
            EntryPoint.class,
            "EntryPoint", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getEntryPoint_InterfaceGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "interfaceGroup", null, 1, 1, EntryPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getEntryPoint_Interface(),
            this.getInterface(),
            null,
            "interface", null, 1, 1, EntryPoint.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getEntryPoint_BindingGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "bindingGroup", null, 1, -1, EntryPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getEntryPoint_Bindings(),
            this.getBinding(),
            null,
            "bindings", null, 1, -1, EntryPoint.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getEntryPoint_ReferenceTargets(),
            theXMLTypePackage.getAnyURI(),
            "referenceTargets", null, 1, -1, EntryPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getEntryPoint_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, EntryPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getEntryPoint_Multiplicity(),
            this.getMultiplicity(),
            "multiplicity", "1..1", 0, 1, EntryPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$ //$NON-NLS-2$
      initEAttribute(
            getEntryPoint_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, EntryPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getEntryPoint_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, EntryPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            externalServiceEClass,
            ExternalService.class,
            "ExternalService", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getExternalService_BindingGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "bindingGroup", null, 0, -1, ExternalService.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getExternalService_Bindings(),
            this.getBinding(),
            null,
            "bindings", null, 0, -1, ExternalService.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getExternalService_InterfaceGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "interfaceGroup", null, 1, 1, ExternalService.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getExternalService_Interface(),
            this.getInterface(),
            null,
            "interface", null, 1, 1, ExternalService.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getExternalService_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, ExternalService.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getExternalService_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, ExternalService.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getExternalService_Overridable(),
            this.getOverrideOptions(),
            "overridable", "may", 0, 1, ExternalService.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$ //$NON-NLS-2$
      initEAttribute(
            getExternalService_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, ExternalService.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            implementationEClass,
            Implementation.class,
            "Implementation", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

      initEClass(
            implementationComponentEClass,
            ImplementationComponent.class,
            "ImplementationComponent", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getImplementationComponent_ImplementationGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "implementationGroup", null, 1, 1, ImplementationComponent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getImplementationComponent_Implementation(),
            this.getImplementation(),
            null,
            "implementation", null, 1, 1, ImplementationComponent.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getImplementationComponent_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, ImplementationComponent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getImplementationComponent_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, ImplementationComponent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            interfaceEClass,
            Interface.class,
            "Interface", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

      initEClass(
            javaImplementationEClass,
            JavaImplementation.class,
            "JavaImplementation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getJavaImplementation_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, JavaImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getJavaImplementation_Class(),
            theXMLTypePackage.getNCName(),
            "class", null, 1, 1, JavaImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getJavaImplementation_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, JavaImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            javaInterfaceEClass,
            JavaInterface.class,
            "JavaInterface", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getJavaInterface_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, JavaInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getJavaInterface_CallbackInterface(),
            theXMLTypePackage.getNCName(),
            "callbackInterface", null, 0, 1, JavaInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getJavaInterface_Interface(),
            theXMLTypePackage.getNCName(),
            "interface", null, 1, 1, JavaInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getJavaInterface_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, JavaInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(moduleEClass, Module.class,
            "Module", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

      initEClass(
            moduleComponentEClass,
            ModuleComponent.class,
            "ModuleComponent", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getModuleComponent_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, ModuleComponent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getModuleComponent_Module(),
            theXMLTypePackage.getNCName(),
            "module", null, 1, 1, ModuleComponent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getModuleComponent_Uri(),
            theXMLTypePackage.getAnyURI(),
            "uri", null, 0, 1, ModuleComponent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getModuleComponent_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, ModuleComponent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            moduleFragmentEClass,
            ModuleFragment.class,
            "ModuleFragment", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getModuleFragment_Wires(),
            this.getModuleWire(),
            null,
            "wires", null, 0, -1, ModuleFragment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getModuleFragment_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, ModuleFragment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getModuleFragment_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, ModuleFragment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            moduleReferenceEClass,
            ModuleReference.class,
            "ModuleReference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getModuleReference_ExternalService(),
            this.getExternalService(),
            null,
            "externalService", null, 1, 1, ModuleReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            moduleServiceEClass,
            ModuleService.class,
            "ModuleService", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getModuleService_EntryPoint(),
            this.getEntryPoint(),
            null,
            "entryPoint", null, 1, 1, ModuleService.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            moduleWireEClass,
            ModuleWire.class,
            "ModuleWire", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getModuleWire_SourceUri(),
            theXMLTypePackage.getAnyURI(),
            "sourceUri", null, 1, 1, ModuleWire.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getModuleWire_TargetUri(),
            theXMLTypePackage.getAnyURI(),
            "targetUri", null, 1, 1, ModuleWire.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getModuleWire_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, ModuleWire.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getModuleWire_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, ModuleWire.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            propertyEClass,
            Property.class,
            "Property", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getProperty_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getProperty_Default(),
            theXMLTypePackage.getString(),
            "default", null, 0, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getProperty_Many(),
            theXMLTypePackage.getBoolean(),
            "many", "false", 0, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$ //$NON-NLS-2$
      initEAttribute(
            getProperty_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getProperty_Required(),
            theXMLTypePackage.getBoolean(),
            "required", "false", 0, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$ //$NON-NLS-2$
      initEAttribute(
            getProperty_Type(),
            theXMLTypePackage.getQName(),
            "type", null, 1, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getProperty_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            propertyValueEClass,
            PropertyValue.class,
            "PropertyValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getPropertyValue_Value(),
            theXMLTypePackage.getAnySimpleType(),
            "value", null, 1, 1, PropertyValue.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getPropertyValue_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, PropertyValue.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            propertyValuesSetEClass,
            PropertyValuesSet.class,
            "PropertyValuesSet", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getPropertyValuesSet_PropertyValues(),
            this.getPropertyValue(),
            null,
            "propertyValues", null, 0, -1, PropertyValuesSet.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getPropertyValuesSet_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, PropertyValuesSet.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            referenceEClass,
            Reference.class,
            "Reference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getReference_InterfaceGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "interfaceGroup", null, 1, 1, Reference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getReference_Interface(),
            this.getInterface(),
            null,
            "interface", null, 1, 1, Reference.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getReference_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, Reference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getReference_Multiplicity(),
            this.getMultiplicity(),
            "multiplicity", "1..1", 0, 1, Reference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$ //$NON-NLS-2$
      initEAttribute(
            getReference_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, Reference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getReference_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, Reference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            referenceValueEClass,
            ReferenceValue.class,
            "ReferenceValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getReferenceValue_TargetURI(),
            theXMLTypePackage.getAnyURI(),
            "targetURI", null, 1, 1, ReferenceValue.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getReferenceValue_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, ReferenceValue.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getReferenceValue_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, ReferenceValue.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getReferenceValue_ReferenceValueSet(),
            this.getReferenceValuesSet(),
            this.getReferenceValuesSet_ReferenceValues(),
            "referenceValueSet", null, 0, 1, ReferenceValue.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            referenceValuesSetEClass,
            ReferenceValuesSet.class,
            "ReferenceValuesSet", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getReferenceValuesSet_ReferenceValues(),
            this.getReferenceValue(),
            this.getReferenceValue_ReferenceValueSet(),
            "referenceValues", null, 0, -1, ReferenceValuesSet.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getReferenceValuesSet_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, ReferenceValuesSet.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getReferenceValuesSet_Component(),
            this.getComponent(),
            this.getComponent_ReferenceValuesSet(),
            "component", null, 0, 1, ReferenceValuesSet.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            scaBindingEClass,
            SCABinding.class,
            "SCABinding", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getSCABinding_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, SCABinding.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getSCABinding_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, SCABinding.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            scaCoreRootEClass,
            SCACoreRoot.class,
            "SCACoreRoot", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getSCACoreRoot_Mixed(),
            ecorePackage.getEFeatureMapEntry(),
            "mixed", null, 0, -1, null, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_XMLNSPrefixMap(),
            ecorePackage.getEStringToStringMapEntry(),
            null,
            "xMLNSPrefixMap", null, 0, -1, null, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_XSISchemaLocation(),
            ecorePackage.getEStringToStringMapEntry(),
            null,
            "xSISchemaLocation", null, 0, -1, null, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_AbstractComponent(),
            this.getComponent(),
            null,
            "abstractComponent", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Binding(),
            this.getBinding(),
            null,
            "binding", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_BindingSca(),
            this.getSCABinding(),
            null,
            "bindingSca", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Component(),
            this.getImplementationComponent(),
            null,
            "component", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_ComponentType(),
            this.getComponentType(),
            null,
            "componentType", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Composite(),
            this.getComposite(),
            null,
            "composite", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Implementation(),
            this.getImplementation(),
            null,
            "implementation", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_ImplementationAbstract(),
            this.getAbstractImplementation(),
            null,
            "implementationAbstract", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_ImplementationUnknown(),
            this.getUnknownImplementation(),
            null,
            "implementationUnknown", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Interface(),
            this.getInterface(),
            null,
            "interface", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Module(),
            this.getModule(),
            null,
            "module", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_ModuleComponent(),
            this.getModuleComponent(),
            null,
            "moduleComponent", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_ModuleFragment(),
            this.getModuleFragment(),
            null,
            "moduleFragment", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Source(),
            ecorePackage.getEObject(),
            null,
            "source", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_SourceEpr(),
            ecorePackage.getEObject(),
            null,
            "sourceEpr", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getSCACoreRoot_SourceUri(),
            theXMLTypePackage.getAnyURI(),
            "sourceUri", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Subsystem(),
            this.getSubsystem(),
            null,
            "subsystem", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_Target(),
            ecorePackage.getEObject(),
            null,
            "target", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_TargetEpr(),
            ecorePackage.getEObject(),
            null,
            "targetEpr", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getSCACoreRoot_TargetUri(),
            theXMLTypePackage.getAnyURI(),
            "targetUri", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_InterfaceWsdl(),
            this.getWSDLPortType(),
            null,
            "interfaceWsdl", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_InterfaceJava(),
            this.getJavaInterface(),
            null,
            "interfaceJava", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_BindingWs(),
            this.getWebServiceBinding(),
            null,
            "bindingWs", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_ImplementationJava(),
            this.getJavaImplementation(),
            null,
            "implementationJava", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSCACoreRoot_BindingEjb(),
            this.getSLSBBinding(),
            null,
            "bindingEjb", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(serviceEClass, Service.class,
            "Service", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getService_InterfaceGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "interfaceGroup", null, 1, 1, Service.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getService_Interface(),
            this.getInterface(),
            null,
            "interface", null, 1, 1, Service.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getService_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, Service.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getService_Name(),
            theXMLTypePackage.getNCName(),
            "name", null, 1, 1, Service.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getService_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, Service.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            slsbBindingEClass,
            SLSBBinding.class,
            "SLSBBinding", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getSLSBBinding_JndiName(),
            theXMLTypePackage.getToken(),
            "jndiName", null, 1, 1, SLSBBinding.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            subsystemEClass,
            Subsystem.class,
            "Subsystem", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEReference(
            getSubsystem_Wires(),
            this.getSystemWire(),
            null,
            "wires", null, 0, -1, Subsystem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getSubsystem_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, Subsystem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getSubsystem_Uri(),
            theXMLTypePackage.getAnyURI(),
            "uri", null, 0, 1, Subsystem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getSubsystem_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, Subsystem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            systemWireEClass,
            SystemWire.class,
            "SystemWire", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getSystemWire_SourceGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "sourceGroup", null, 1, 1, SystemWire.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSystemWire_Source(),
            ecorePackage.getEObject(),
            null,
            "source", null, 1, 1, SystemWire.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getSystemWire_TargetGroup(),
            ecorePackage.getEFeatureMapEntry(),
            "targetGroup", null, 1, 1, SystemWire.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEReference(
            getSystemWire_Target(),
            ecorePackage.getEObject(),
            null,
            "target", null, 1, 1, SystemWire.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getSystemWire_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, SystemWire.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            unknownImplementationEClass,
            UnknownImplementation.class,
            "UnknownImplementation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getUnknownImplementation_Uri(),
            theXMLTypePackage.getAnyURI(),
            "uri", null, 1, 1, UnknownImplementation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            webServiceBindingEClass,
            WebServiceBinding.class,
            "WebServiceBinding", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getWebServiceBinding_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, WebServiceBinding.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getWebServiceBinding_Port(),
            theXMLTypePackage.getAnyURI(),
            "port", null, 1, 1, WebServiceBinding.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getWebServiceBinding_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, WebServiceBinding.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      initEClass(
            wsdlPortTypeEClass,
            WSDLPortType.class,
            "WSDLPortType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEAttribute(
            getWSDLPortType_Any(),
            ecorePackage.getEFeatureMapEntry(),
            "any", null, 0, -1, WSDLPortType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getWSDLPortType_CallbackInterface(),
            theXMLTypePackage.getAnyURI(),
            "callbackInterface", null, 0, 1, WSDLPortType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getWSDLPortType_Interface(),
            theXMLTypePackage.getAnyURI(),
            "interface", null, 1, 1, WSDLPortType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
      initEAttribute(
            getWSDLPortType_AnyAttribute(),
            ecorePackage.getEFeatureMapEntry(),
            "anyAttribute", null, 0, -1, WSDLPortType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

      // Initialize enums and add enum literals
      initEEnum(overrideOptionsEEnum, OverrideOptions.class, "OverrideOptions"); //$NON-NLS-1$
      addEEnumLiteral(overrideOptionsEEnum, OverrideOptions.NO_LITERAL);
      addEEnumLiteral(overrideOptionsEEnum, OverrideOptions.MAY_LITERAL);
      addEEnumLiteral(overrideOptionsEEnum, OverrideOptions.MUST_LITERAL);

      // Initialize data types
      initEDataType(multiplicityEDataType, String.class,
            "Multiplicity", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
      initEDataType(
            overrideOptionsObjectEDataType,
            OverrideOptions.class,
            "OverrideOptionsObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

      // Create resource
      createResource(eNS_URI);

      // Create annotations
      // http:///org/eclipse/emf/ecore/util/ExtendedMetaData
      createExtendedMetaDataAnnotations();
   }

   /**
    * Initializes the annotations for
    * <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void createExtendedMetaDataAnnotations() {
      String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData"; //$NON-NLS-1$		
      addAnnotation(abstractImplementationEClass, source, new String[] {
            "name", "AbstractImplementation", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getAbstractImplementation_ComponentType(), source,
            new String[] { "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
                  "name", "componentType", //$NON-NLS-1$ //$NON-NLS-2$
                  "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
            });
      addAnnotation(getAbstractImplementation_Type(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "type" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(bindingEClass, source, new String[] { "name", "Binding", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "empty" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getBinding_Uri(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "uri" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(componentEClass, source, new String[] {
            "name", "Component", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComponent_PropertyValuesSet(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "properties" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComponent_ReferenceValuesSet(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "references" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComponent_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(componentTypeEClass, source, new String[] {
            "name", "ComponentType", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComponentType_Services(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "service" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComponentType_References(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "reference" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComponentType_Properties(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "property" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComponentType_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":3", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComponentType_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":4", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(compositeEClass, source, new String[] {
            "name", "Composite", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComposite_EntryPoints(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "entryPoint" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComposite_ComponentsGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "abstractComponent:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComposite_Components(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "abstractComponent", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "abstractComponent:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComposite_ExternalServices(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "externalService" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getComposite_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(entryPointEClass, source, new String[] {
            "name", "EntryPoint", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_InterfaceGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_Interface(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "interface:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_BindingGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "binding:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_Bindings(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "binding", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "binding:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_ReferenceTargets(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "reference" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":5", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_Multiplicity(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "multiplicity" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getEntryPoint_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":8", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(externalServiceEClass, source, new String[] {
            "name", "ExternalService", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getExternalService_BindingGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "binding:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getExternalService_Bindings(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "binding", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "binding:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getExternalService_InterfaceGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getExternalService_Interface(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "interface:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getExternalService_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":4", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getExternalService_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getExternalService_Overridable(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "overridable" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getExternalService_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":7", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(implementationEClass, source, new String[] {
            "name", "Implementation", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "empty" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(implementationComponentEClass, source, new String[] {
            "name", "ImplementationComponent", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getImplementationComponent_ImplementationGroup(), source,
            new String[] { "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
                  "name", "implementation:group", //$NON-NLS-1$ //$NON-NLS-2$
                  "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
            });
      addAnnotation(getImplementationComponent_Implementation(), source,
            new String[] { "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
                  "name", "implementation", //$NON-NLS-1$ //$NON-NLS-2$
                  "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
                  "group", "implementation:group" //$NON-NLS-1$ //$NON-NLS-2$
            });
      addAnnotation(getImplementationComponent_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":5", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getImplementationComponent_AnyAttribute(), source,
            new String[] { "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
                  "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
                  "name", ":6", //$NON-NLS-1$ //$NON-NLS-2$
                  "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
            });
      addAnnotation(interfaceEClass, source, new String[] {
            "name", "Interface", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "empty" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(javaImplementationEClass, source, new String[] {
            "name", "JavaImplementation", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getJavaImplementation_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":0", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getJavaImplementation_Class(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "class" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getJavaImplementation_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":2", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(javaInterfaceEClass, source, new String[] {
            "name", "JavaInterface", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getJavaInterface_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":0", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getJavaInterface_CallbackInterface(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "callbackInterface" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getJavaInterface_Interface(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getJavaInterface_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":3", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(moduleEClass, source, new String[] { "name", "Module", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(moduleComponentEClass, source, new String[] {
            "name", "ModuleComponent", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleComponent_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":3", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleComponent_Module(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "module" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleComponent_Uri(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "uri" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleComponent_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":6", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(moduleFragmentEClass, source, new String[] {
            "name", "ModuleFragment", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleFragment_Wires(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "wire" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleFragment_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":6", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleFragment_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":7", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(moduleReferenceEClass, source, new String[] {
            "name", "ModuleReference", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleReference_ExternalService(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "externalService" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(moduleServiceEClass, source, new String[] {
            "name", "ModuleService", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleService_EntryPoint(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "entryPoint" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(moduleWireEClass, source, new String[] {
            "name", "ModuleWire", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleWire_SourceUri(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "source.uri", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleWire_TargetUri(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "target.uri", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleWire_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":2", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getModuleWire_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":3", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(multiplicityEDataType, source, new String[] {
            "name", "Multiplicity", //$NON-NLS-1$ //$NON-NLS-2$
            "baseType", "http://www.eclipse.org/emf/2003/XMLType#string", //$NON-NLS-1$ //$NON-NLS-2$
            "enumeration", "0..1 1..1 0..n 1..n" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(overrideOptionsEEnum, source, new String[] {
            "name", "OverrideOptions" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(overrideOptionsObjectEDataType, source, new String[] {
            "name", "OverrideOptions:Object", //$NON-NLS-1$ //$NON-NLS-2$
            "baseType", "OverrideOptions" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(propertyEClass, source, new String[] { "name", "Property", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getProperty_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":0", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getProperty_Default(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "default" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getProperty_Many(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "many" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getProperty_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getProperty_Required(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "required" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getProperty_Type(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "type" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getProperty_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":6", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(propertyValueEClass, source, new String[] {
            "name", "PropertyValue", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getPropertyValue_Value(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "value" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getPropertyValue_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(propertyValuesSetEClass, source, new String[] {
            "name", "PropertyValuesSet", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getPropertyValuesSet_PropertyValues(), source,
            new String[] { "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
                  "name", "property" //$NON-NLS-1$ //$NON-NLS-2$
            });
      addAnnotation(getPropertyValuesSet_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":1", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(referenceEClass, source, new String[] {
            "name", "Reference", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReference_InterfaceGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReference_Interface(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "interface:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReference_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":2", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReference_Multiplicity(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "multiplicity" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReference_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReference_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":5", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(referenceValueEClass, source, new String[] {
            "name", "ReferenceValue", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReferenceValue_TargetURI(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "target" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReferenceValue_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReferenceValue_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":2", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(referenceValuesSetEClass, source, new String[] {
            "name", "ReferenceValuesSet", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getReferenceValuesSet_ReferenceValues(), source,
            new String[] { "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
                  "name", "reference" //$NON-NLS-1$ //$NON-NLS-2$
            });
      addAnnotation(getReferenceValuesSet_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":1", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(scaBindingEClass, source, new String[] {
            "name", "SCABinding", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCABinding_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":1", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCABinding_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":2", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(scaCoreRootEClass, source, new String[] { "name", "", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "mixed" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Mixed(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":mixed" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_XMLNSPrefixMap(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "xmlns:prefix" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_XSISchemaLocation(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "xsi:schemaLocation" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_AbstractComponent(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "abstractComponent", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Binding(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "binding", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_BindingSca(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "binding.sca", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "binding" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Component(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "component", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "abstractComponent" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_ComponentType(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "componentType", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Composite(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "composite", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Implementation(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "implementation", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_ImplementationAbstract(), source,
            new String[] { "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
                  "name", "implementation.abstract", //$NON-NLS-1$ //$NON-NLS-2$
                  "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
                  "affiliation", "implementation" //$NON-NLS-1$ //$NON-NLS-2$
            });
      addAnnotation(getSCACoreRoot_ImplementationUnknown(), source,
            new String[] { "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
                  "name", "implementation.unknown", //$NON-NLS-1$ //$NON-NLS-2$
                  "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
                  "affiliation", "implementation" //$NON-NLS-1$ //$NON-NLS-2$
            });
      addAnnotation(getSCACoreRoot_Interface(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Module(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "module", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_ModuleComponent(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "moduleComponent", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "abstractComponent" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_ModuleFragment(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "moduleFragment", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Source(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "source", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_SourceEpr(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "source.epr", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "source" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_SourceUri(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "source.uri", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "source" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Subsystem(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "subsystem", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_Target(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "target", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_TargetEpr(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "target.epr", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "target" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_TargetUri(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "target.uri", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "target" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_InterfaceWsdl(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface.wsdl", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "interface" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_InterfaceJava(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface.java", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "interface" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_BindingWs(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "binding.ws", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "binding" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_ImplementationJava(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "implementation.java", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "implementation" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSCACoreRoot_BindingEjb(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "binding.ejb", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "affiliation", "binding" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(serviceEClass, source, new String[] { "name", "Service", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getService_InterfaceGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getService_Interface(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "interface:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getService_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":2", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getService_Name(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "name" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getService_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":4", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(slsbBindingEClass, source, new String[] {
            "name", "SLSBBinding", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "empty" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSLSBBinding_JndiName(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "jndiName" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(subsystemEClass, source, new String[] {
            "name", "Subsystem", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSubsystem_Wires(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "wire" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSubsystem_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":6", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSubsystem_Uri(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "uri" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSubsystem_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":8", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(systemWireEClass, source, new String[] {
            "name", "SystemWire", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSystemWire_SourceGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "source:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSystemWire_Source(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "source", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "source:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSystemWire_TargetGroup(), source, new String[] {
            "kind", "group", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "target:group", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSystemWire_Target(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "target", //$NON-NLS-1$ //$NON-NLS-2$
            "namespace", "##targetNamespace", //$NON-NLS-1$ //$NON-NLS-2$
            "group", "target:group" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getSystemWire_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":4", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(unknownImplementationEClass, source, new String[] {
            "name", "UnknownImplementation", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getUnknownImplementation_Uri(), source, new String[] {
            "kind", "element", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "uri" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(webServiceBindingEClass, source, new String[] {
            "name", "WebServiceBinding", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getWebServiceBinding_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":1", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getWebServiceBinding_Port(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "port" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getWebServiceBinding_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":3", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(wsdlPortTypeEClass, source, new String[] {
            "name", "WSDLPortType", //$NON-NLS-1$ //$NON-NLS-2$
            "kind", "elementOnly" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getWSDLPortType_Any(), source, new String[] {
            "kind", "elementWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##other", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":0", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getWSDLPortType_CallbackInterface(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "callbackInterface" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getWSDLPortType_Interface(), source, new String[] {
            "kind", "attribute", //$NON-NLS-1$ //$NON-NLS-2$
            "name", "interface" //$NON-NLS-1$ //$NON-NLS-2$
      });
      addAnnotation(getWSDLPortType_AnyAttribute(), source, new String[] {
            "kind", "attributeWildcard", //$NON-NLS-1$ //$NON-NLS-2$
            "wildcards", "##any", //$NON-NLS-1$ //$NON-NLS-2$
            "name", ":3", //$NON-NLS-1$ //$NON-NLS-2$
            "processing", "lax" //$NON-NLS-1$ //$NON-NLS-2$
      });
   }

} // SCAPackageImpl
