/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.util;

/**
 * Type constants for SCA
 */
public class SCAType {
   /**
    * Type for a Module element. The contaning resource is 'sca.composite'
    */
   public final static String COMPOSITE      = "COMPOSITE";     //$NON-NLS-1$

   /**
    * Type for a Module element. The contaning resource is 'sca.module'
    */
   public final static String MODULE         = "MODULE";        //$NON-NLS-1$

   /**
    * Type for Component element. The containing resource is '<component
    * name>.component'
    */
   public final static String COMPONENT      = "COMPONENT";     //$NON-NLS-1$	

   /**
    * Type for Reference.
    */
   public final static String REFERENCE      = "REFERENCE";     //$NON-NLS-1$

   /**
    * Type for Reference.
    */
   public final static String PROPERTY       = "PROPERTY";      //$NON-NLS-1$

   /**
    * Type for an service.
    */
   public final static String SERVICE        = "INTERFACE";     //$NON-NLS-1$	

   /**
    * Type for an implementation.
    */
   public final static String IMPLEMENTATION = "IMPLEMENTATION"; //$NON-NLS-1$

   /**
    * Type for an Component type.
    */
   public static final Object COMPONENT_TYPE = "COMPONENT_TYPE"; //$NON-NLS-1$
}
