/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.editors;

import java.util.Arrays;
import java.util.Iterator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.stp.soas.internal.deploy.ui.editors.SelectionProviderManagedForm;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/**
 * @author rcernich
 * 
 * Created on Mar 8, 2004
 */
public class EMFFormPage extends FormPage implements
		IResourceEditingContainer {

	private SelectionProviderManagedForm mForm;

	/**
	 * @param editor
	 * @param id
	 * @param title
	 */
	public EMFFormPage(EMFFormEditor editor, String id, String title) {
		super(editor, id, title);
	}

	/**
	 * @param id
	 * @param title
	 */
	public EMFFormPage(String id, String title) {
		super(id, title);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.IFormPage#initialize(org.eclipse.ui.forms.editor.FormEditor)
	 */
	public void initialize(FormEditor editor) {
		if (!(editor instanceof EMFFormEditor)) {
			throw new IllegalArgumentException(
					"Editor must be of type" + EMFFormEditor.class);
		}
		super.initialize(editor);
	}

	public EMFFormEditor getEMFFormEditor() {
		return (EMFFormEditor) getEditor();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		// WORKAROUND: Make sure the parts get initialized. Use SelectionProviderManagedForm
		// to make sure selection events propagate.
		ScrolledForm form = getEditor().getToolkit().createScrolledForm(parent);
		mForm = new SelectionProviderManagedForm(this, form);
		BusyIndicator.showWhile(parent.getDisplay(), new Runnable() {

			public void run() {
				createFormContent(mForm);
				mForm.initialize();
				EObject modelRoot = getEMFFormEditor().getModelRoot();
				for (Iterator it = Arrays.asList(mForm.getParts()).iterator(); it
						.hasNext();) {
					IFormPart ifp = (IFormPart) it.next();
					if (ifp instanceof EMFSectionPart) {
						((EMFSectionPart) ifp).setModelRoot(modelRoot);
					}
				}
			}
		});
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.IFormPage#getManagedForm()
	 */
	public IManagedForm getManagedForm() {
		return mForm;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.IFormPage#setActive(boolean)
	 */
	public void setActive(boolean active) {
		if (active) {
			// We are switching to this page - refresh it
			// if needed.
			mForm.refresh();
		}
	}

	public Control getPartControl() {
		return mForm != null ? mForm.getForm() : null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#dispose()
	 */
	public void dispose() {
		if (mForm != null) {
			mForm.dispose();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void setFocus() {
		if (mForm != null) {
			mForm.setFocus();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
		if (mForm != null) {
			mForm.commit(true);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isDirty()
	 */
	public boolean isDirty() {
		return mForm != null ? mForm.isDirty() : false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.IFormPage#selectReveal(java.lang.Object)
	 */
	public boolean selectReveal(Object object) {
		if (mForm != null) {
			return mForm.setInput(object);
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.editors.IResourceEditingContainer#getModelRoot()
	 */
	public EObject getModelRoot() {
		return getEMFFormEditor().getModelRoot();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.editors.IResourceEditingContainer#getResource()
	 */
	public Resource getResource() {
		return getEMFFormEditor().getResource();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.edit.domain.IEditingDomainProvider#getEditingDomain()
	 */
	public EditingDomain getEditingDomain() {
		return getEMFFormEditor().getEditingDomain();
	}
}