/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class TextFieldVerifyListener implements VerifyListener {

    private static final Logger LOG = Logger.getLogger(TextFieldVerifyListener.class.getName());
    
    private String pattern;

    public TextFieldVerifyListener(String p) {
        super();
        pattern = p;
    }
    
    public void verifyText(VerifyEvent event) {
        LOG.log(Level.FINE, "TEST - verifyText");
        LOG.log(Level.FINE, "   event.text: " + event.text);
        LOG.log(Level.FINE, "   event.text.length: " + event.text.length());
        LOG.log(Level.FINE, "   event.character: " + event.character);
        LOG.log(Level.FINE, "   event.keyCode: " + event.keyCode);
        if (event.keyCode == 0) {
            return;
        }
        
        if (!(event.widget instanceof Combo || event.widget instanceof Text)) {
            return;
        }

        // determine what the new text string would be...
        Combo combo = null;
        String curText = "";
        if (event.widget instanceof Combo) {
            combo = (Combo) event.widget;
            curText = combo.getText();
        } else {
            Text text = (Text) event.widget;
            curText = text.getText();
        }
        String newText = curText.substring(0, event.start)
                         + event.text
                         + curText.substring(event.end, curText.length());
        
        // on Linux - there is a transitional event that occurs, where the
        // event.text is empty, but the event.character contains the actual
        // key that was typed.  If that occurred, get a transitional newText
        // for verification.
        if (newText.length() == 0 && !Character.isISOControl(event.character)) {
            newText = newText + event.character;
        }

        // if a combo, first check if it matches a value in the preset list
        if (combo != null) {
            String[] presetItems = combo.getItems();
            for (int i = 0; i < presetItems.length; i++) {
                if (presetItems[i].equals(newText)) {
                    return;
                }
            }
        }

        // didn't match preset list, MUST conform to specified pattern
        if (pattern != null) {
            if (newText.length() != 0 && !newText.matches(pattern)) {
                // invalid string
                event.doit = false;
                return;
            }
        }
    }

}
