/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.xef;

/** This interface defines operations that allow an object to represent itself as an XML string, and 
 * allow the Object to be reinitialized based on XML. 
 */
public interface IXMLProvider {
    /**
     * The QName of the element that should be taken as the root element that contains all the editable 
     * XML elements. This element should be specified using the QName format {http://namespace}Localname
     * @return the name of the element that should be used as root.  
     */
    String getRootElementQName();
    
    /**
     * Obtain the XML representation of the object(s).
     * @return The XML.
     */    
    String getXML();
    
    /** Writes the XML back, which should reinitialize the object, based on the XML.
     * @param xml The changed xml.
     */
    void setXML(String xml);
}
