/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.util.ArrayList;
import java.util.List;


import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.actions.ActionFactory;

class DeleteElementAction extends Action {
    boolean interactive = true; // set to false for testing to avoid modal dialog box from popping up

    private final XefEditMasterDetailsBlock block;
    private final XefEditPage editPage;

    DeleteElementAction(XefEditMasterDetailsBlock b, XefEditPage page) {
        super(ActionFactory.DELETE.getId());
        block = b;
        editPage = page;
    }

    @Override
    public void run() {
        ISelection sel = block.viewer.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        
        IStructuredSelection ssel = (IStructuredSelection) sel;
        Object el = ssel.getFirstElement();
        
        List<XMLInstanceElement> toBeDeleted = new ArrayList<XMLInstanceElement>();
        if (el instanceof XMLInstanceElement) {
            toBeDeleted.add((XMLInstanceElement) el);
        } else if (el instanceof SnippetRepresentingXMLInstanceElements) {
            toBeDeleted.addAll(((SnippetRepresentingXMLInstanceElements) el).getElements());
        }
        
        if (toBeDeleted.size() == 0) {
            return;
        }
        
        boolean goAhead = !interactive 
            || MessageDialog.openQuestion(editPage.getSite().getShell(), "Delete Policy", "Delete " + el.toString() + "?");
        if (!goAhead) {
            return;
        }
        
        for (XMLInstanceElement pi : toBeDeleted) {
            if (pi.getParent() == null) {
                block.policies.remove(pi);
                block.setDirty(true);
            } else {
                pi.getParent().removeChild(pi);
                block.setDirty(true);
            }
        }
        block.viewer.refresh();
    }

    @Override
    public String getText() {
        return "Delete";
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return editPage.getSite().getWorkbenchWindow().getWorkbench().getSharedImages().getImageDescriptor(
                ISharedImages.IMG_TOOL_DELETE);
    }
}
