/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import org.eclipse.swt.widgets.Text;

public class PasswordControlAccessor implements ControlAccessor {
    private final TextFilter textFilter;
    private final Text primaryText;   
    private Text secondaryText;
    private String filteredValue;
    
    PasswordControlAccessor(Text t, TextFilter filter) {
	if (filter == null) {
		throw new NullPointerException("Password Control has incorrectly configured password filter.");
	}
	
        textFilter = filter;
	primaryText = t;
    }
    
    Text getPrimaryText() {
        return primaryText;
    }

    Text getSecondaryText() {
        return secondaryText;
    }

    public void setSecondaryText(Text t) {
	secondaryText = t;
    }
    
    public String getValue() {
        if (!primaryText.getText().equals(filteredValue)) {
            filteredValue = textFilter.filter(primaryText.getText());
            
            if (!primaryText.isFocusControl()) {
                primaryText.setText(filteredValue);
                secondaryText.setText(filteredValue);
            }
        }        
        
        return filteredValue;
    }

    public void setValue(String value) {
        filteredValue = value;
	
        primaryText.setText(value);
        if (secondaryText != null) {
            secondaryText.setText(value);
        }        
    }
}
