/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.schema;

/** A context provider provides information to the XEF editor based on current conditions in
 * the context. This type of information cannot be provided through the XML Schema as 
 * it depends on the state of other elements in the system.
 */
public interface IContextProvider {
	/**
	 * Get values for a particular context ID. This context ID is specified in the XML Schema
	 * using <xefgui:context><xefgui:values>ctxId</xefgui:value></xefgui:context> tags in the <xs:appinfo>
	 * tag of an attribute. It is used to build a selection list in the GUI that the end user 
	 * can pick a value from.
	 * @param ctxId The context ID to look up.
     * @param ctxFilter Context specific filter to match against 
	 * @return The possible values.
	 */
    public String[] getValues(String ctxId, String ctxFilter);
    
    /**
     * Get the data for a particular context ID.  This context ID is specified in the XML
     * Schema using <xefgui:context><xefgui:data>ctxId</xefgui:value></xefgui:context> tags in 
     * the <xs:appinfo> tag of an attribute.  It is used to get additional data the may be useful for
     * advanced field editing functionality.
     * @param ctxId The context ID to look up.
     * @return The data associated with that ID.
     */
    public Object getData(String ctxId);

}
