/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.xef;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class SimpleSchemaProvider implements ISchemaProvider {
    private final String namespace;
    private final String schema;
    
    public SimpleSchemaProvider(String namespace, String schema) {
        this.namespace = namespace;
        this.schema = schema;
    }

    public String getSchema(String namespace) {
        return schema;
    }

    public String getSnippet(String name) {
		return null;
	}

	public Collection<String> listSchemaNamespaces(String filter) {
        return Arrays.asList(new String [] {namespace});
    }

	public Collection<String> listSnippets(String filter) {
		return Collections.emptyList();
	}

	public void refresh() { }
}
