/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui;

import org.eclipse.stp.b2j.ui.internal.misc.BaseImageManager;

public class B2jImageManager extends BaseImageManager
{
	public static final B2jImageManager INSTANCE = new B2jImageManager();
	
	public static final String FOLDER_OBJ16 =	"obj16";

	public static final String IMG_DEFAULT =	"default.gif";
	
	public static final String IMG_TESTSUITE =		"testsuite.gif";
	public static final String IMG_TESTCASE =		"testcase.gif";
	public static final String IMG_BEHAVIOUR =		"behaviour.gif";
	public static final String IMG_SERVICES =		"services.gif";
	public static final String IMG_SERVICEFILE =	"servicefile.gif";
	public static final String IMG_DISTRIBUTION =	"distribution.gif";
	public static final String IMG_HOST =			"host.gif";
	public static final String IMG_MAJOR_CONTROLLER ="maj_controller.gif";
	public static final String IMG_MINOR_CONTROLLER ="min_controller.gif";
	public static final String IMG_BOTH_CONTROLLER ="both_controller.gif";
	public static final String IMG_TRANSPORT =		"transport.gif";
	public static final String IMG_WSDLBINDING =	"wsdlbinding.gif";
	public static final String IMG_JAR =			"jar.gif";
	public static final String IMG_JAR_IMPORT =		"jar_import.gif";
	public static final String IMG_FILES =			"files.gif";
	public static final String IMG_FILE =			"file.gif";
	public static final String IMG_COMPILATION =	"sut_obj.gif";
	
	public static final String IMG_XML =			"xml.gif";
	public static final String IMG_REMOVE =			"remove.gif";
	public static final String IMG_RUN =			"run.gif";

	protected void addImages()
	{
		add(FOLDER_OBJ16, IMG_DEFAULT);
		
		add(FOLDER_OBJ16, IMG_TESTSUITE);
		add(FOLDER_OBJ16, IMG_TESTCASE);
		add(FOLDER_OBJ16, IMG_BEHAVIOUR);
		add(FOLDER_OBJ16, IMG_SERVICES);
		add(FOLDER_OBJ16, IMG_SERVICEFILE);
		add(FOLDER_OBJ16, IMG_DISTRIBUTION);
		add(FOLDER_OBJ16, IMG_HOST);
		add(FOLDER_OBJ16, IMG_MAJOR_CONTROLLER);
		add(FOLDER_OBJ16, IMG_MINOR_CONTROLLER);
		add(FOLDER_OBJ16, IMG_BOTH_CONTROLLER);
		add(FOLDER_OBJ16, IMG_TRANSPORT);
		add(FOLDER_OBJ16, IMG_WSDLBINDING);
		add(FOLDER_OBJ16, IMG_JAR);
		add(FOLDER_OBJ16, IMG_JAR_IMPORT);
		add(FOLDER_OBJ16, IMG_FILES);
		add(FOLDER_OBJ16, IMG_FILE);
		add(FOLDER_OBJ16, IMG_COMPILATION);
		
		add(FOLDER_OBJ16, IMG_XML);
		add(FOLDER_OBJ16, IMG_REMOVE);
		add(FOLDER_OBJ16, IMG_RUN);
	}
}
