/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.launchconfig;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.stp.b2j.ui.B2jImageManager;
import org.eclipse.stp.b2j.ui.UiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LaunchConfigTranslatorTab extends AbstractLaunchConfigurationTab implements SelectionListener, ILaunchConfigurationTab, KeyListener {

	private static final String VERBOSE = "translator_verbose";
	private static final String HEADLESS = "translator_headless";

	Composite main;
	
	Button verbose;
	Button headless;
	
	String message;
	String error_message;

	public void checkForErrors() {
		error_message = null;
	}

	public boolean isValid(ILaunchConfiguration launchConfig) {
		return error_message == null;
	}
	
	public String getErrorMessage() {
		return error_message;
	}
	
	public String getMessage() {
		return message;
	}
	
	public void setDirty(boolean b) {
		super.setDirty(b);
		checkForErrors();
		updateLaunchConfigurationDialog();
	}
	
	public void createControl(Composite parent) {
		
		main = new Composite(parent,SWT.NONE);
		main.setLayout(new GridLayout(1,false));
		verbose = new Button(main,SWT.CHECK);
		verbose.setText(UiPlugin.getString("VERBOSE_COMPILATION"));
		headless = new Button(main,SWT.CHECK);
		headless.setText(UiPlugin.getString("HEADLESS_ENGINE"));

		//
		// event handling
		//
		
		verbose.addSelectionListener(this);
		headless.addSelectionListener(this);
	}
	
	public Control getControl() {
		return main;
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(VERBOSE,false);
	}

	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
			verbose.setSelection(configuration.getAttribute(VERBOSE,false));
			headless.setSelection(configuration.getAttribute(HEADLESS,false));
		} catch (CoreException e) {
			e.printStackTrace();
		}
		checkForErrors();
	}

	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(VERBOSE,verbose.getSelection());
		configuration.setAttribute(HEADLESS,headless.getSelection());
	}

	public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
		initializeFrom(workingCopy);
	}
	
	public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
		performApply(workingCopy);
	}
	
	public String getName() {
		return UiPlugin.getString("TRANSLATOR_TAB_NAME");
	}

	public Image getImage() {
		return UiPlugin.imageManager.getImage(B2jImageManager.IMG_COMPILATION);
	}
	
	public void dispose() {
		try {
			main.dispose();
		} catch (Exception e) {
		}
	}

	//
	// Event handlers
	//
	
	public void keyPressed(KeyEvent e) {
		setDirty(true);
	}

	public void keyReleased(KeyEvent e) {
		setDirty(true);
	}

	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		
		if (o == verbose) {
			setDirty(true);
		} else if (o == headless) {
			setDirty(true);
		}
		
		checkForErrors();
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}

}