/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider;


import org.eclipse.swt.graphics.Image;

public class BPELProviderNode {
	String name;
	String id;
	String categoryId;
	BPELProvider provider;
	ImageProvider imgProvider;
	
	public BPELProviderNode(String name, String id, String categoryId, BPELProvider provider, ImageProvider imgProvider) {
		this.name = name;
		this.id = id;
		this.categoryId = categoryId;
		this.provider = provider;
		this.imgProvider = imgProvider;
		
		if (this.categoryId == null) this.categoryId = "";
	}
	
	public String getName() {
		return name;
	}
	public String getId() {
		return id;
	}
	public String getCategoryId() {
		return categoryId;
	}
	
	public BPELProvider getProvider() {
		return provider;
	}
	
	public Image getImage() {
		if (imgProvider == null) return null;
		return imgProvider.getImage(id);
	}
	
	public String toString() {
		return name;
	}
}