/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.exception;

/**
 * This exception is thrown by methods in ISAFManager to report
 * errors when an operation invoked by the client program cannot be
 * performed. The error message may be displayed
 * to the user in an error dialog, so it should be easy to understand.
 */
public class InvalidOperationException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5506166310947551473L;

	/**
	 * Creates an exception object from an error message. The message will
	 * potentially be displayed to the user through an error dialog, so it must
	 * be easy to understand.
	 * 
	 * @param message
	 *            translated text describing the error
	 */
	public InvalidOperationException(String message) {
		super(message);
	}

	/**
	 * Creates an exception object from an error message and another exception.
	 * The message will potentially be displayed to the user through an error
	 * dialog, so it must be easy to understand.
	 * 
	 * @param message
	 *            translated text describing the error
	 * @param cause
	 *            the base exception object
	 */
	public InvalidOperationException(String message, Throwable cause) {
		super(message, cause);
	}

}
