/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class PropertyCreationOperation extends AbstractScribblerOperation {
   public PropertyCreationOperation(IDataModel model) {
      super(model);
   }

   protected IStatus doExecute(IProgressMonitor monitor)
         throws ExecutionException {
      ComponentType componentType = (ComponentType) model
            .getProperty(IPropertyCreationDataModelProperties.COMPONENT_TYPE);

      Property createdProperty = SCAPackage.eINSTANCE.getSCAFactory()
            .createProperty();
      createdProperty.setName(model
            .getStringProperty(IPropertyCreationDataModelProperties.NAME));
      createdProperty
            .setDefault(model
                  .getStringProperty(IPropertyCreationDataModelProperties.DEFAULT_VALUE));
      createdProperty.setType(model
            .getProperty(IPropertyCreationDataModelProperties.TYPE));
      createdProperty.setRequired(model
            .getBooleanProperty(IPropertyCreationDataModelProperties.REQUIRED));
      createdProperty.setMany(model
            .getBooleanProperty(IPropertyCreationDataModelProperties.MANY));

      componentType.getProperties().add(createdProperty);
      model.setProperty(IAbstractScribblerDataModelProperties.RESULT,
            createdProperty);
      return OK_STATUS;
   }

   protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }

   protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }
}
