/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;
import org.eclipse.stp.core.resources.SOAConstants;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ReferenceCreationOperation extends AbstractScribblerOperation {
   public ReferenceCreationOperation(IDataModel model) {
      super(model);
   }

   protected IStatus doExecute(IProgressMonitor monitor)
         throws ExecutionException {

      ComponentType componentType = (ComponentType) model
            .getProperty(IReferenceCreationDataModelProperties.COMPONENT_TYPE);

      Reference reference = SCAPackage.eINSTANCE.getSCAFactory()
            .createReference();
      reference.setName(model
            .getStringProperty(IReferenceCreationDataModelProperties.NAME));

      Interface interface_ = null;
      String interfaceType = model
            .getStringProperty(IServiceCreationDataModelProperties.INTERFACE_TYPE);
      if (interfaceType.equals(SOAConstants.JAVA_INTERFACE)) {
         interface_ = SCAFactory.eINSTANCE.createJavaInterface();
         ((JavaInterface) interface_)
               .setInterface(model
                     .getStringProperty(IReferenceCreationDataModelProperties.INTERFACE));
      } else if (interfaceType.equals(SOAConstants.WSDL_PORTYPE)) {
         interface_ = SCAFactory.eINSTANCE.createWSDLPortType();
         ((WSDLPortType) interface_)
               .setInterface(model
                     .getStringProperty(IReferenceCreationDataModelProperties.INTERFACE));
      }
      if (interface_ != null)
         reference.setInterface(interface_);

      reference
            .setMultiplicity(model
                  .getStringProperty(IReferenceCreationDataModelProperties.MULTIPLICITY));

      componentType.getReferences().add(reference);

      model
            .setProperty(IAbstractScribblerDataModelProperties.RESULT,
                  reference);
      return OK_STATUS;
   }

   protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }

   protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }
}
