/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.edit.operations;

import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ChangePropertyDataModelProvider extends
      AbstractScribblerDataModelProvider implements
      IChangePropertyDataModelProperties {

   public ChangePropertyDataModelProvider() {
      super();
      // TODO Auto-generated constructor stub
   }

   public Set getPropertyNames() {
      Set propertyNames = super.getPropertyNames();
      propertyNames.add(PROPERTY);
      propertyNames.add(NEW_NAME);
      propertyNames.add(NEW_TYPE);
      propertyNames.add(NEW_DEFAULT_VALUE);
      propertyNames.add(NEW_MANY);
      propertyNames.add(NEW_REQUIRED);

      return propertyNames;
   }

   public IStatus validate(String propertyName) {
      if (propertyName.equals(PROPERTY)) {
         validateProperty();
      } else if (propertyName.equals(NEW_NAME)) {
         return validateNewName();
      } else if (propertyName.equals(NEW_TYPE)) {
         return validateNewType();
      } else if (propertyName.equals(NEW_DEFAULT_VALUE)) {
         return validateNewDefaultValue();
      }
      return super.validate(propertyName);
   }

   public IDataModelOperation getDefaultOperation() {
      return new ChangePropertyOperation(model);
   }

   private IStatus validateProperty() {
      Object obj = model.getProperty(PROPERTY);
      if (obj == null || !(obj instanceof Property))
         return STPCorePlugin.createErrorStatus(
               Messages.invalidObjectPassed_errorText, null);

      return OK_STATUS;
   }

   private IStatus validateNewName() {
      String newName = getStringProperty(NEW_NAME);

      if (newName == null || newName.length() <= 0)
         return STPCorePlugin.createErrorStatus(
               Messages.newNameBlank_errorText, null);

      // TODO check if a property with same name exists or not?
      // if yes
      // return STPCorePlugin.createErrorStatus("A Property with the same name
      // already exists. Try a different name", null);

      return Status.OK_STATUS;
   }

   private IStatus validateNewDefaultValue() {
      return Status.OK_STATUS;
   }

   private IStatus validateNewType() {
      return Status.OK_STATUS;
   }
}
