/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Implementation Component</b></em>'.
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.ImplementationComponent#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ImplementationComponent#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getImplementationComponent()
 * @model features="implementationGroup implementation"
 *        implementationGroupType="org.eclipse.emf.ecore.util.FeatureMap$Entry"
 *        implementationGroupUnique="false"
 *        implementationGroupDataType="org.eclipse.emf.ecore.EFeatureMapEntry"
 *        implementationGroupRequired="true"
 *        implementationGroupSuppressedGetVisibility="true"
 *        implementationGroupSuppressedSetVisibility="true"
 *        implementationGroupExtendedMetaData="kind='group'
 *        name='implementation:group' namespace='##targetNamespace'"
 *        implementationType="org.eclipse.stp.core.sca.Implementation"
 *        implementationContainment="true" implementationResolveProxies="false"
 *        implementationRequired="true" implementationTransient="true"
 *        implementationVolatile="true" implementationDerived="true"
 *        implementationSuppressedGetVisibility="true"
 *        implementationSuppressedSetVisibility="true"
 *        implementationExtendedMetaData="kind='element' name='implementation'
 *        namespace='##targetNamespace' group='implementation:group'"
 *        extendedMetaData="name='ImplementationComponent' kind='elementOnly'"
 * @generated
 */
public interface ImplementationComponent extends Component {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Any</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any</em>' attribute list isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getImplementationComponent_Any()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard'
    *        wildcards='##other' name=':5' processing='lax'"
    * @generated
    */
   FeatureMap getAny();

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getImplementationComponent_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':6' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

} // ImplementationComponent
