/**
 * <copyright> </copyright>
 * 
 * $Id: SystemWireImpl.java,v 1.2 2006/04/05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.SystemWire;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>System Wire</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.SystemWireImpl#getSourceGroup <em>Source Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SystemWireImpl#getSource <em>Source</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SystemWireImpl#getTargetGroup <em>Target Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SystemWireImpl#getTarget <em>Target</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SystemWireImpl#getAny <em>Any</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class SystemWireImpl extends SCAInternalObjectImpl implements SystemWire {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright   = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getSourceGroup() <em>Source Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getSourceGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap       sourceGroup = null;

   /**
    * The cached value of the '{@link #getTargetGroup() <em>Target Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getTargetGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap       targetGroup = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap       any         = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SystemWireImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getSystemWire();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getSourceGroup() {
      if (sourceGroup == null) {
         sourceGroup = new BasicFeatureMap(this,
               SCAPackage.SYSTEM_WIRE__SOURCE_GROUP);
      }
      return sourceGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object getSource() {
      return (Object) getSourceGroup().get(
            SCAPackage.eINSTANCE.getSystemWire_Source(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetSource(EObject newSource,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getSourceGroup()).basicAdd(
            SCAPackage.eINSTANCE.getSystemWire_Source(), newSource, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setSource(Object newSource) {
      ((FeatureMap.Internal) getSourceGroup()).set(SCAPackage.eINSTANCE
            .getSystemWire_Source(), newSource);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getTargetGroup() {
      if (targetGroup == null) {
         targetGroup = new BasicFeatureMap(this,
               SCAPackage.SYSTEM_WIRE__TARGET_GROUP);
      }
      return targetGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object getTarget() {
      return (Object) getTargetGroup().get(
            SCAPackage.eINSTANCE.getSystemWire_Target(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetTarget(EObject newTarget,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getTargetGroup()).basicAdd(
            SCAPackage.eINSTANCE.getSystemWire_Target(), newTarget, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setTarget(Object newTarget) {
      ((FeatureMap.Internal) getTargetGroup()).set(SCAPackage.eINSTANCE
            .getSystemWire_Target(), newTarget);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.SYSTEM_WIRE__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.SYSTEM_WIRE__SOURCE_GROUP:
               return ((InternalEList) getSourceGroup()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.SYSTEM_WIRE__SOURCE:
               return basicSetSource(null, msgs);
            case SCAPackage.SYSTEM_WIRE__TARGET_GROUP:
               return ((InternalEList) getTargetGroup()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.SYSTEM_WIRE__TARGET:
               return basicSetTarget(null, msgs);
            case SCAPackage.SYSTEM_WIRE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SYSTEM_WIRE__SOURCE_GROUP:
            return getSourceGroup();
         case SCAPackage.SYSTEM_WIRE__SOURCE:
            return getSource();
         case SCAPackage.SYSTEM_WIRE__TARGET_GROUP:
            return getTargetGroup();
         case SCAPackage.SYSTEM_WIRE__TARGET:
            return getTarget();
         case SCAPackage.SYSTEM_WIRE__ANY:
            return getAny();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SYSTEM_WIRE__SOURCE_GROUP:
            getSourceGroup().clear();
            getSourceGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.SYSTEM_WIRE__SOURCE:
            setSource((Object) newValue);
            return;
         case SCAPackage.SYSTEM_WIRE__TARGET_GROUP:
            getTargetGroup().clear();
            getTargetGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.SYSTEM_WIRE__TARGET:
            setTarget((Object) newValue);
            return;
         case SCAPackage.SYSTEM_WIRE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SYSTEM_WIRE__SOURCE_GROUP:
            getSourceGroup().clear();
            return;
         case SCAPackage.SYSTEM_WIRE__SOURCE:
            setSource((Object) null);
            return;
         case SCAPackage.SYSTEM_WIRE__TARGET_GROUP:
            getTargetGroup().clear();
            return;
         case SCAPackage.SYSTEM_WIRE__TARGET:
            setTarget((Object) null);
            return;
         case SCAPackage.SYSTEM_WIRE__ANY:
            getAny().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SYSTEM_WIRE__SOURCE_GROUP:
            return sourceGroup != null && !sourceGroup.isEmpty();
         case SCAPackage.SYSTEM_WIRE__SOURCE:
            return getSource() != null;
         case SCAPackage.SYSTEM_WIRE__TARGET_GROUP:
            return targetGroup != null && !targetGroup.isEmpty();
         case SCAPackage.SYSTEM_WIRE__TARGET:
            return getTarget() != null;
         case SCAPackage.SYSTEM_WIRE__ANY:
            return any != null && !any.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (sourceGroup: "); //$NON-NLS-1$
      result.append(sourceGroup);
      result.append(", targetGroup: "); //$NON-NLS-1$
      result.append(targetGroup);
      result.append(", any: "); //$NON-NLS-1$
      result.append(any);
      result.append(')');
      return result.toString();
   }

} // SystemWireImpl
