/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;


/**
 * @author rcernich
 *
 * Created on Apr 8, 2004
 */
public interface ISupportedServerType {

	/**
	 * Returns the type of server that the packages produced by this extension
	 * may be deployed to.
	 * 
	 * @return the supported server type
	 */
	IServerDefinition getServerDefinition();
	
	/**
	 * Returns the minimum supported version of the server that packages
	 * produced by this extension may be deployed to.
	 * 
	 * @return the minimum supported server version.
	 */
	IVersion getMinVersion();
	
	/**
	 * Returns the maximum supported version of the server that packages
	 * produced by this extension may be deployed to.  Note that match rules
	 * govern the actual maximum version (e.g. this maximum may be 3.0.0.0, but
	 * a match rule of compatible would allow packages produced by this
	 * extension to be targeted to a server whose version is 3.1.0.0, but not to
	 * a server whose version is 4.0.0.0).
	 * 
	 * @return the maximum supported server version.
	 */
	IVersion getMaxVersion();
	
	/**
	 * Returns the match rule that should be used to determine whether or not
	 * a package produced by this extension may be deployed to a server of a
	 * particular version.
	 * 
	 * @return the match rule to use when verifying compatibility with a target
	 * server.
	 */
	MatchRule getVersionMatchRule();
	
	boolean supportsServer(IServerType type);
	
}
