/*******************************************************************************
 * Copyright (c) 2003-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

/**
 * This class is used by the deployment framework when gathering techonology
 * type information for packages and server deployment extensions.
 * 
 * @author rcernich
 *
 * Created on Nov 13, 2003
 */
public interface ITechnologyType {
	
	ITechnologyDefinition getTechnologyDefinition();

	/**
	 * @return the version of this technology type.
	 */
	IVersion getVersion();

	/**
	 * @param o
	 * @return getTechnologyDefinition().equals(getTechnologyDefinition()) && getVersion().equals(o.getVersion())
	 */
	boolean equals(Object o);
	
	/**
	 * @return an appropriate hash code (e.g. getTechnologyDefinition().hashCode())
	 */
	int hashCode();

}
