/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.adapters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;


/**
 * @author rcernich
 * 
 * Created on Feb 24, 2005
 */
public class DeployAdapterFactory implements IAdapterFactory {

	/**
	 *  
	 */
	public DeployAdapterFactory() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object,
	 *      java.lang.Class)
	 */
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		Object adapted;
		// Note the order is important here since some of the types are
		// are subtypes of other types. Check the lowest type in the
		// hierarchy first.
		if (IConfigurablePackage.class.isAssignableFrom(adapterType)) {
			adapted = DeploymentExtensionManager.getInstance()
					.getConfigurablePackage((IFile) adaptableObject);
		}
		else if (ILogicalPackage.class.isAssignableFrom(adapterType)) {
			adapted = DeploymentExtensionManager.getInstance()
					.getLogicalPackage((IFile) adaptableObject);
		}
		else if (IPhysicalPackage.class.isAssignableFrom(adapterType)) {
			adapted = DeploymentExtensionManager.getInstance()
					.getPhysicalPackage((IFile) adaptableObject);
		}
		else if (IPackage.class.isAssignableFrom(adapterType)) {
			adapted = DeploymentExtensionManager.getInstance().getPackage(
					(IFile) adaptableObject);
		}
		else {
			adapted = null;
		}
		return adapted;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapterList()
	 */
	public Class[] getAdapterList() {
		return new Class[] { IPackage.class, IPhysicalPackage.class,
				ILogicalPackage.class, IConfigurablePackage.class};
	}

}