/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/**
 * @author rcernich
 * 
 * Created on Jan 17, 2005
 */
public class IntroductionSection extends DeployEditorSectionPart {

	public static final String SECTION_TITLE = DeployCorePlugin
			.getDefault().getResourceString(
					"DeployDefinitionEditor.SECTITLE.Introduction"); //$NON-NLS-1$
	public static final String SECTION_DESC = DeployCorePlugin
			.getDefault().getResourceString(
					"DeployDefinitionEditor.SECDESC.Introduction"); //$NON-NLS-1$

	private Collection mImages = new ArrayList();

	/**
	 * @param parent
	 * @param toolkit
	 * @param style
	 */
	public IntroductionSection(Composite parent, FormToolkit toolkit, int style) {
		super(parent, toolkit, style);
		getSection().setText(SECTION_TITLE);
		getSection().setDescription(SECTION_DESC);
	}

	public void createClient(FormToolkit toolkit) {
		Composite container = toolkit.createComposite(getSection());
		TableWrapLayout layout = new TableWrapLayout();
		layout.numColumns = 2;
		layout.makeColumnsEqualWidth = false;
		layout.horizontalSpacing = 20;
		layout.verticalSpacing = 20;
		container.setLayout(layout);

		Label label = toolkit.createLabel(container, null, SWT.NONE);
		label.setImage(DeployCorePlugin.getDefault().getImage(
				"deploydef_72.gif")); //$NON-NLS-1$
		mImages.add(label.getImage());
		TableWrapData data = new TableWrapData();
		data.rowspan = 2;
		label.setLayoutData(data);

		label = toolkit.createLabel(container, DeployCorePlugin
				.getDefault().getResourceString(
						"IntroductionSection.LABEL.IntroductionHeading")); //$NON-NLS-1$
		label.setFont(JFaceResources.getHeaderFont());

		FormText text = toolkit.createFormText(container, false);
		text.setText(DeployCorePlugin.getDefault().getResourceString(
				"IntroductionSection.TEXT.Introduction"), false, false); //$NON-NLS-1$		

		// START
		label = toolkit.createLabel(container, null, SWT.NONE);
		label.setImage(DeployCorePlugin.getDefault().getImage(
				"gotoeditor_obj.gif")); //$NON-NLS-1$
		mImages.add(label.getImage());
		data = new TableWrapData();
		data.rowspan = 2;
		label.setLayoutData(data);

		Hyperlink hyperlink = toolkit.createHyperlink(container, DeployCorePlugin
				.getDefault().getResourceString(
						"IntroductionSection.HYPERLINK.Start"), SWT.NONE); //$NON-NLS-1$
		hyperlink.addHyperlinkListener(new HyperlinkAdapter() {

			public void linkActivated(HyperlinkEvent event) {
				startLinkActivated(event);
			}
		});

		text = toolkit.createFormText(container, false);
		text.setText(DeployCorePlugin.getDefault().getResourceString(
				"IntroductionSection.TEXT.Start"), false, false); //$NON-NLS-1$		

		// TUTORIAL
		label = toolkit.createLabel(container, null, SWT.NONE);
		label.setImage(DeployCorePlugin.getDefault().getImage(
				"tutorials_obj.gif")); //$NON-NLS-1$
		mImages.add(label.getImage());
		data = new TableWrapData();
		data.rowspan = 2;
		label.setLayoutData(data);
		hyperlink = toolkit.createHyperlink(container,
				DeployCorePlugin.getDefault().getResourceString(
						"IntroductionSection.HYPERLINK.Tutorial"), SWT.NONE); //$NON-NLS-1$
		hyperlink.addHyperlinkListener(new HyperlinkAdapter() {

			public void linkActivated(HyperlinkEvent event) {
				tutorialLinkActivated(event);
			}
		});

		text = toolkit.createFormText(container, false);
		text.setText(DeployCorePlugin.getDefault().getResourceString(
				"IntroductionSection.TEXT.Tutorial"), false, false); //$NON-NLS-1$		

		// OVERVIEW
		label = toolkit.createLabel(container, null, SWT.NONE);
		label.setImage(DeployCorePlugin.getDefault().getImage(
				"overview_obj.gif")); //$NON-NLS-1$
		mImages.add(label.getImage());
		data = new TableWrapData();
		data.rowspan = 2;
		label.setLayoutData(data);

		hyperlink = toolkit.createHyperlink(container, DeployCorePlugin
				.getDefault().getResourceString(
						"IntroductionSection.HYPERLINK.Overview"), SWT.NONE); //$NON-NLS-1$
		hyperlink.addHyperlinkListener(new HyperlinkAdapter() {

			public void linkActivated(HyperlinkEvent event) {
				overviewLinkActivated(event);
			}
		});

		text = toolkit.createFormText(container, false);
		text.setText(DeployCorePlugin.getDefault().getResourceString(
				"IntroductionSection.TEXT.Overview"), false, false); //$NON-NLS-1$		

		getSection().setClient(container);

		toolkit.paintBordersFor(container);
	}

    protected void helpActivated(HyperlinkEvent event)
    {
       HelpUtilities.displayHelp(IHelpConstants.CONTEXT_ID_INTRODUCTION_PAGE_INTRODUCTION_SECTION);
    }

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.editors.EMFSectionPart#setModelRoot(org.eclipse.emf.ecore.EObject)
	 */
	protected void setModelRoot(EObject modelRoot) {
	}

	private void tutorialLinkActivated(HyperlinkEvent event) {
		OpenCheatSheetAction action = new OpenCheatSheetAction(
				IHelpConstants.HELP_DEPLOY_CHEATSHEET_ID);
		action.run();
	}

	private void overviewLinkActivated(HyperlinkEvent event) {
		PlatformUI.getWorkbench().getHelpSystem()
				.displayHelpResource(IHelpConstants.HELP_DEPLOY_OVERVIEW_HREF);
	}

	private void startLinkActivated(HyperlinkEvent event) {
		getEMFFormEditor().setActivePage(DeployEditor.ID_OVERVIEW);
	}

	public void dispose() {
		for (Iterator it = mImages.iterator(); it.hasNext();) {
			((Image)it.next()).dispose();
		}
		super.dispose();
	}
}
