/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip.TCPIPTransportProvider;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemon;
import org.eclipse.stp.b2j.core.misc.internal.Debugger;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class B2jPlugin extends AbstractUIPlugin implements BundleActivator {

	public static final String DEBUG_MODEL_ID = "org.eclipse.tptp.choregraphy.debug.model";

	public static Debugger DBG = new Debugger(Util.plugin_package);

	//The shared instance.
	private static B2jPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public B2jPlugin() {
		plugin = this;

		DBG.setPlugin(this);
	}
	
	public static int getDefaultSoapDaemonPort() {
		return SoapDaemon.DAEMON_PORT;
	}
	
	public static SessionTransportProvider[] getDefaultSessionTransportProviders() {
		return new SessionTransportProvider[]{new TCPIPTransportProvider()};
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static B2jPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.stp.b2j", path);
	}

	//
	// Plugin.properties string stuff
	//
	
	private ResourceBundle resourceBundle;

	private void loadResourceBundle() {
		if (resourceBundle == null) {
			resourceBundle = Platform.getResourceBundle(getBundle());
		}
	}
	
	public static String getString(String key) 
	{
		getDefault().loadResourceBundle();
		try
		{
			String ret = getDefault().resourceBundle.getString(key);
			if (ret == null) return key;
			return ret;
		}
		catch (NullPointerException e)
		{
			return key;
		}
		catch (MissingResourceException e)
		{
			return key;
		}
	}
	
	public static String getString(String key, String arg)
	{
		getDefault().loadResourceBundle();
		return getString(key, new String[]{arg});
	}
	
	public static String getString(String key, String[] args)
	{
		getDefault().loadResourceBundle();
		return replaceString(getDefault().resourceBundle.getString(key),args);
	}
	
	private static String replaceString(String key, String[] args) {
		StringBuffer sb = new StringBuffer(key);

		for (int i = 0; i < args.length; i++) {
			if (args[i] == null) continue;

			String search = "%"+(i+1);
			int searchlen = search.length();

			int n = indexOf(sb,search,0);	
//			int n = sb.indexOf(search);
			while (n != -1) {
				sb.replace(n,n+searchlen,args[i]);
//				n = sb.indexOf(search,n);
				n = indexOf(sb,search,n);
			}
		}
		
		return sb.toString();
	}
	

	public static int indexOf(StringBuffer in, String str, int fromIndex)
	{
		if(in == null)
			return -1;
		
		if(str == null)
			str = "";
			
		int lengthIn = in.length();
		int lengthStr = str.length();

		if(lengthIn < lengthStr)
			return -1;

		if(fromIndex > lengthIn)
		{
			if (lengthIn == 0 && fromIndex == 0 && lengthStr == 0)
				return 0;
			return -1;
		}
		
		if(fromIndex < 0)
			fromIndex = 0;
			
		if(lengthStr == 0)
			return fromIndex;
			
		int strPos = 0;
		for(int i=fromIndex; i<lengthIn; i++)
		{
			if(in.charAt(i) == str.charAt(strPos))
			{
				strPos++;
				if(strPos == lengthStr)
					return i-lengthStr+1;
			}
			else
				strPos = 0;	
		}
		
		return -1;
	}
	
	
}
