/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.api;

import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 * 
 * Part of the generic engine client API, used to represent an engine Daemon which
 * can create new engine instances to run engine Programs.
 */
public interface DaemonInterface {
	public ControllerInterface newEngine(String description, TraceListener tl, JARDependency[] jar_dependencies, SessionAddress address) throws Exception;
	public void close();
}