/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

public class BPELFault extends RuntimeException {
	
	String name;
	String wsdlMessageQName;
	String xsdElementQName;
	String contents;
	
	Throwable underlyingThrowable;
	
	public Throwable getUnderlyingThrowable() {
		return underlyingThrowable;
	}
	
	public BPELFault(String name) {
		super(name);
	}
	public BPELFault(Throwable t) {
		super(t);
		underlyingThrowable = t;
//		this.initCause(t);
	}
	
	public String getFaultName() {
		return name;
	}
	public String getContents() {
		return contents;
	}
	public String getWsdlMessageQName() {
		return wsdlMessageQName;
	}
	public String getXsdElementQName() {
		return xsdElementQName;
	}
	
	public boolean hasContents() {
		return contents != null;
	}
	public boolean isWsdlMessageType() {
		return wsdlMessageQName != null;
	}
	public boolean isXsdElementType() {
		return xsdElementQName != null;
	}
	
	public void setWsdlMessageType(String wsdlMessageQName, String contents) {
		this.wsdlMessageQName = wsdlMessageQName;
		this.contents = contents;
		xsdElementQName = null;
	}

	public void setXsdElementType(String xsdElementQName, String contents) {
		this.xsdElementQName = xsdElementQName;
		this.contents = contents;
		wsdlMessageQName = null;
	}
}