/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLOperation;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLPortType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslatorException;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

/**
 * 
 * @author amiguel
 *
 * The engine internal messaging binding type translator.
 */
public class InternalMessageBindingTranslator implements WSDLBindingTranslator, InternalBindingTranslator {

public static final String UNSPECIFIED_ADDRESS = "~";
	
UIDPool uidpool = new UIDPool();
	
public static final String NAMESPACE_ENGINEBINDING = NamespaceTranslator.NAMESPACE_ENGINE;

HashMap conversations = new HashMap();
int CONVERSATION_ID = 0;

int PICK_ID = 0;

MessageCodec codec_message;
XMLCodec codec_xml;

XSDTypeTranslator[] codecs;

class Binding {
	String qname;
	String qportType;
	String bindingName;
	
	String address_location = UNSPECIFIED_ADDRESS;
}

HashMap bindings = new HashMap();

WSDLMap wsdlmap;
XSDMap xsdmap;

NamespaceTranslator engNT;

ClassLoader dependancy_loader;

TranslatorLog log;
Util compiler_util;

	public String getID() {
		return getClass().getName();
	}
	
	public String getHumanReadableName() {
//		return B2jPlugin.getString("BINDING_TYPE_INTERNAL");
		return "Internal Messaging Binding";
	}

//	public String getProviderPluginName() {
//		return B2jPlugin.getDefault().getBundle().getSymbolicName();
//	}

	public void init(Util compiler_util, TranslatorLog log, XSDMap xsdmap, WSDLMap wsdlmap, ClassLoader dependancy_loader) {
		this.xsdmap = xsdmap;
		this.wsdlmap = wsdlmap;
		this.dependancy_loader = dependancy_loader;
		this.compiler_util = compiler_util;
		this.log = log;
		
		codec_message = new MessageCodec();
		codec_xml = new XMLCodec();
	
		codecs = new XSDTypeTranslator[] {
			codec_message,	
			codec_xml,	
		};
	}

	private boolean isBindingOurs(NamespaceTranslator nt, Element elem) throws NamespaceException {
		if (engNT == null) {
			engNT = compiler_util.createNamespaceTranslator();
			engNT.addNamespace("xmlns:engine",NAMESPACE_ENGINEBINDING);
		}
		
		ArrayList elems = Util.getAllElements(elem);
		for (int i = 0; i < elems.size(); i++) {
			Element engbinding = (Element)elems.get(i);
			nt.addNamespaces(engbinding);
			if (nt.checkQName(engbinding,NAMESPACE_ENGINEBINDING,"binding")) {
				return true;
			}
			nt.removeNamespaces(engbinding);
		}
		return false;
	}
	
	public void readWSDL(Element wsdl_definitions) throws NamespaceException, WSDLBindingTranslatorException {
		NamespaceTranslator nt = compiler_util.createNamespaceTranslator();
		nt.addNamespaces(wsdl_definitions);
		
		ArrayList elems = Util.getAllElements(wsdl_definitions);
		for (int i = 0; i < elems.size(); i++) {
			Element elem = (Element)elems.get(i);
			nt.addNamespaces(elem);

			if (NamespaceTranslator.getName(elem).equals("binding")) {
				//we've found a binding
				//get the port type
				String ptype = elem.getAttribute("type");
				if (isBindingOurs(nt,elem)) {
					
					Binding binding = new Binding();
					binding.qname = nt.qualify(elem.getTagName(),true);
					binding.qportType = nt.qualify(ptype,false);
					binding.bindingName = nt.qualify(elem.getAttribute("name"),true);
					
					System.out.println("FOUND ENGINE BINDING: "+binding.bindingName);
					
					//add two entries, one referencing it via the port type, one via the binding type
					bindings.put(binding.qportType,binding);
					bindings.put(binding.qname,binding);
					bindings.put(binding.bindingName,binding);
				}
				
			} else if (NamespaceTranslator.getName(elem).equals("service")) {
				
				ArrayList ports = Util.getAllElements(elem);
				for (int k = 0; k < ports.size(); k++) {
					Element port = (Element)ports.get(k);
					
					nt.addNamespaces(port);
					
					if (NamespaceTranslator.getName(port).equals("port")) {
						Binding binding = (Binding)bindings.get(nt.qualify(port.getAttribute("binding"),false));
						
						if (binding != null) {
							//ok, this is talking about one of our bindings
							
							ArrayList addresses = Util.getAllElements(port);
							for (int z = 0; z < addresses.size(); z++) {
								Element address = (Element)addresses.get(z);
								
								nt.addNamespaces(address);
								if (nt.checkQName(address,NAMESPACE_ENGINEBINDING,"address")) {
									binding.address_location = address.getAttribute("conversation");
								}
								nt.removeNamespaces(address);
							}
						}
					}
						
					nt.removeNamespaces(port);
				}
			}
			
			nt.removeNamespaces(elem);
		}
		//
		// we don't need to care about service elements
		// we will never be copying around internal engine EPRs
		//
		
		nt.removeNamespaces(wsdl_definitions);
	}

	public XSDTypeTranslator[] getCodecs() {
		return codecs;
	}

	private void checkForBindingNamed(String name) throws WSDLBindingTranslatorException {
		//no exact binding specified
		if (name == null) return;
		Binding binding = (Binding)bindings.get(name);
		if (binding == null) {
			throw new WSDLBindingTranslatorException("no Engine Internal Message binding found named '"+compiler_util.getQNameFromQName(name)+"'");
		}
	}
	
	private void checkForBinding(String qportType) throws WSDLBindingTranslatorException {
		Binding binding = (Binding)bindings.get(qportType);
		if (binding == null) {
			throw new WSDLBindingTranslatorException("no Engine Internal Message binding found for port type "+compiler_util.getQNameFromQName(qportType));
		}
	}
	
	private String getConversationID(String qportType, String operation, boolean request) {
		String conversationKey = qportType+"."+operation;
		
		Integer cid = (Integer)conversations.get(qportType+"."+operation);
		if (cid == null) {
			cid = new Integer(CONVERSATION_ID++);
			conversations.put(conversationKey,cid);
		}
		
		if (request) {
			//request
			return "\"->:"+cid+"\"";
		} else {
			//response
			return "\"<-:"+cid+"\"";
		}
	}
	
	public String translateInvocation(NamespaceTranslator nt, String qportType, String bindingName, String operation, String eprFieldName, String correlationSetFieldNameIn, String correlationSetFieldNameOut, String inputFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
		StringBuffer sb = new StringBuffer();

		checkForBindingNamed(bindingName);
		checkForBinding(qportType);
		
		WSDLPortType wsdlPortType = wsdlmap.getPortType(qportType);
		WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);
		
		String conversationRequestID = getConversationID(qportType,operation,true);
		String conversationResponseID = getConversationID(qportType,operation,false);
		
		//TODO compile in munging of the conversation IDs based on correlation sets here
		//NOTE that probably won't be enough.  I'll need to have something else happening here
		//Need some kind of distributed version of the PortHolder thing where I can filter existing
		//conversations by correlation set
		//This is all good for now though, we can add this later

		sb.append("if ("+eprFieldName+".getAddress().equals(org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.InternalMessageBindingTranslator.UNSPECIFIED_ADDRESS)) throw new BPELFault(\"Unable to invoke "+wsdlPortType.getName()+"."+operation+", no address specified in EPR\");\n");
		
		if (wsdlOp.getType() == WSDLOperation.TYPE_REQUEST_RESPONSE) {
			if (outputFieldName.length() == 0) {
				throw new WSDLBindingTranslatorException("WSDL operation is of type Request-response but no output variable specified");
			}
			
			sb.append(outputFieldName).append(" = ");
			sb.append("engine.sendAndReceiveMessage(");
			sb.append(conversationRequestID+"+\"@\"+"+eprFieldName+".getAddress()");
			sb.append(",");
			sb.append(inputFieldName);
			sb.append(",");
			sb.append(conversationResponseID+"+\"@\"+"+eprFieldName+".getAddress()");
			sb.append(");\n");
		} else if (wsdlOp.getType() == WSDLOperation.TYPE_ONEWAY) {
//			sb.append(outputFieldName).append(" = ");
			sb.append("engine.sendMessage(");
			sb.append(conversationRequestID+"+\"@\"+"+eprFieldName+".getAddress()");
			sb.append(",");
			sb.append(inputFieldName);
			sb.append(");\n");
		} else {
			throw new WSDLBindingTranslatorException("Unsupported WSDL operation type - only One-way and Request-response are supported (if this is supposed to be request-response, check ordering of <in> and <out>)");
		}
		
		return sb.toString();
	}
	public String translateReceive(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
		StringBuffer sb = new StringBuffer();

		checkForBindingNamed(bindingName);
		checkForBinding(qportType);

		WSDLPortType wsdlPortType = wsdlmap.getPortType(qportType);
		WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);

		String conversationRequestID = getConversationID(qportType,operation,true);
		
		sb.append("if ("+eprFieldName+".getAddress().equals(org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.InternalMessageBindingTranslator.UNSPECIFIED_ADDRESS)) throw new BPELFault(\"Unable to receive on "+wsdlPortType.getName()+"."+operation+", no address specified in EPR\");\n");
		sb.append(inputFieldName).append(" = ");
		sb.append("engine.receiveMessage(");
		sb.append(conversationRequestID+"+\"@\"+"+eprFieldName+".getAddress()");
		sb.append(");\n");
		
		return sb.toString();
	}
	public String translateReply(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
		StringBuffer sb = new StringBuffer();

		checkForBindingNamed(bindingName);
		checkForBinding(qportType);
		
		WSDLPortType wsdlPortType = wsdlmap.getPortType(qportType);
		WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);

		String conversationResponseID = getConversationID(qportType,operation,false);
		
		sb.append("if ("+eprFieldName+".getAddress().equals(org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.InternalMessageBindingTranslator.UNSPECIFIED_ADDRESS)) throw new BPELFault(\"Unable to reply to "+wsdlPortType.getName()+"."+operation+", no address specified in EPR\");\n");
		sb.append("engine.sendMessage(");
		sb.append(conversationResponseID+"+\"@\"+"+eprFieldName+".getAddress()");
		sb.append(",");
		sb.append(outputFieldName);
		sb.append(");\n");
		
		return sb.toString();
	}
	public String translateDefaultEPR(NamespaceTranslator nt, String qportType, String bindingName) throws NamespaceException, WSDLBindingTranslatorException {
		StringBuffer sb = new StringBuffer();

		checkForBindingNamed(bindingName);
		checkForBinding(qportType);

		Binding binding = (Binding)bindings.get(qportType);
		
		if (bindingName != null) {
			//use a specific binding (and therefore use a specific binding's EPR)
			binding = (Binding)bindings.get(bindingName);
		}

//		sb.append("new WSEndpointReference(\"\")");
		sb.append("new WSEndpointReference(\""+TranslatorUtils.toJavaStringStrict(binding.address_location)+"\")");
		
		return sb.toString();
	}

StringBuffer picksb;
String pickConversationId;
String pickTimeoutId;
//String pickTimeoutIndex;
int index;
ArrayList inputFields;

	public void translatePickStart(int onMessageCount, int onAlarmCount, String pickTimeoutId) throws NamespaceException, WSDLBindingTranslatorException {
		picksb = new StringBuffer();
		index = 0;
		inputFields = new ArrayList();
		
		this.pickTimeoutId = pickTimeoutId;
		
		pickConversationId = "engine_internal_pick"+(PICK_ID++);
//		pickTimeoutId = "engine_internal_pick_timeout"+(PICK_ID++);
//		pickTimeoutIndex = "engine_internal_pick_shortest_timeout"+(PICK_ID++);
		
		picksb.append("String[] "+pickConversationId+" = new String["+onMessageCount+"];\n");
//		if (onAlarmCount > 0) {
//			picksb.append("long "+pickTimeoutId+" = Long.MAX_VALUE;\n");
//		} else {
//			picksb.append("long "+pickTimeoutId+" = 0;\n");
//		}
//		picksb.append("int "+pickTimeoutIndex+" = 0;\n");
	}
	public void translatePickOnMessage(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException {

		inputFields.add(inputFieldName);
		
		checkForBindingNamed(bindingName);
		checkForBinding(qportType);

		WSDLPortType wsdlPortType = wsdlmap.getPortType(qportType);
		WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);

		String conversationRequestID = getConversationID(qportType,operation,true);
		
		picksb.append("if ("+eprFieldName+".getAddress().equals(org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.InternalMessageBindingTranslator.UNSPECIFIED_ADDRESS)) throw new BPELFault(\"Unable to pick on "+wsdlPortType.getName()+"."+operation+", no address specified in EPR\");\n");
		
		// 
		// append each conversation into the conversation array
		//
		picksb.append(pickConversationId+"["+index+"] = "+conversationRequestID+"+\"@\"+"+eprFieldName+".getAddress();\n");
		
		index++;
	}
/*	
	public void translatePickOnAlarm(String timeoutFieldLongMs) throws NamespaceException, BindingTranslatorException {
		picksb.append("if ("+timeoutFieldLongMs+" <= "+pickTimeoutId+") {\n");
		picksb.append("  "+pickTimeoutId+" = "+timeoutFieldLongMs+";\n");
		picksb.append("  "+pickTimeoutIndex+" = "+index+";\n");
		picksb.append("}\n");
		index++;
	}
*/	
	public String translatePickFinish(String indexFieldName)  throws NamespaceException, WSDLBindingTranslatorException {

		String pickedMessage = "engine_internal_pick_message"+(PICK_ID++);

		//
		// Receive the message
		//
		picksb.append("Message ");
		picksb.append(pickedMessage).append(" = ");
		picksb.append("engine.receiveMessage(");
		picksb.append(pickConversationId);
		picksb.append(",");
		picksb.append(pickTimeoutId);
		picksb.append(");\n");
		
		//
		// Pop the successful conversation off the end of the message and set the indexFieldName accordingly
		//
		String pickedConversationId = "engine_internal_pick_conversation"+(PICK_ID++);

		picksb.append("if ("+pickedMessage+" == null) {\n");
		picksb.append("  //timeout\n");
		picksb.append("  "+indexFieldName+" = -1;\n");
//		picksb.append("  "+indexFieldName+" = "+pickTimeoutIndex+";\n");
		picksb.append("} else {\n");
		picksb.append("  //received a message\n");
		picksb.append("String "+pickedConversationId+" = (String)"+pickedMessage+".pop();\n");
		
		for (int i = 0; i < inputFields.size(); i++) {
			if (i > 0) {
				picksb.append("} else ");
			}
			picksb.append("if ("+pickedConversationId+".equals("+pickConversationId+"["+i+"])) {\n");
			
			picksb.append("  "+inputFields.get(i)+" = "+pickedMessage+";\n");
			picksb.append("  "+indexFieldName+" = "+i+";\n");
			
			if (i == (inputFields.size()-1)) {
				picksb.append("}\n");
			}
		}
		picksb.append("}\n");
		
		return picksb.toString();
	}
	
	
	public String getDeclarations() {
		StringBuffer decl = new StringBuffer();
		return decl.toString();
	}
	public String[] getImports() {
		return new String[] {
		};
	}
}