/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;

import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;

/**
 * 
 * @author amiguel
 *
 * A SOAP client implementation used by the SOAP binding
 */
public class SOAPClient {

	public static void invokeOneWay(WSEndpointReference epr, BPELCorrelationSet cset, String transportUri, boolean rpc_type, String operationNamespace, String operation, String soapAction, String wsdl_message) throws Exception {
		try {
			
			SOAPClientTransport transport = SOAPFactory.getClientTransportForEPR(epr,cset,transportUri);
			
			if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT INVOKE: (one-way) "+operationNamespace+" "+operation+" "+soapAction);		
	
			if (rpc_type) {
				//create the SOAP envelope around the WSDL message
				wsdl_message = SOAPUtils.basicWrapInSoapEnvelopeRPC(wsdl_message,operationNamespace,operation);
				
				if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT SENT (rpc/one-way): "+wsdl_message);		
	
				transport.send(wsdl_message,soapAction);
			} else {
				//create the SOAP envelope around the WSDL message
				wsdl_message = SOAPUtils.basicWrapInSoapEnvelopeDocument(wsdl_message);
				
				if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT SENT (doc/one-way): () "+wsdl_message);		
				
				transport.send(wsdl_message,soapAction);
			}
			
			transport.close();
		} catch (Exception e) {
			throw new SOAPException("SOAP Client Transaction Failed",wsdl_message,null,rpc_type,operationNamespace,operation,soapAction,e);
		}
	}
	
	public static String invokeRequestResponse(WSEndpointReference epr, BPELCorrelationSet cset, String transportUri, boolean rpc_type, String operationNamespace, String operation, String soapAction, String wsdl_message) throws Exception {
		String wsdl_response = null;
		try {
			SOAPClientTransport transport = SOAPFactory.getClientTransportForEPR(epr,cset,transportUri);
			
			if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT INVOKE: (req-res) "+operationNamespace+" "+operation+" "+soapAction);		
	
			if (rpc_type) {
				//create the SOAP envelope around the WSDL message
				wsdl_message = SOAPUtils.basicWrapInSoapEnvelopeRPC(wsdl_message,operationNamespace,operation);
	
				if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT SENT (rpc/req-res): "+wsdl_message);		
				
			} else {
				//create the SOAP envelope around the WSDL message
				wsdl_message = SOAPUtils.basicWrapInSoapEnvelopeDocument(wsdl_message);
				
				if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT SENT (doc/req-res): "+wsdl_message);		
	
			}
		
			//get the response
			wsdl_response = transport.sendAndReceive(wsdl_message,soapAction);
		
			if (rpc_type) {
				if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT RECEIVED (rpc): "+wsdl_response);		
				
				//parse out the SOAP envelope around the response WSDL message
				wsdl_response = SOAPUtils.basicRemoveSoapEnvelopeRPC(wsdl_response);
				
				if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT STRIPPED TO (rpc): "+wsdl_response);		
				
			} else {
				if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT RECEIVED (doc): "+wsdl_response);		
				
				//parse out the SOAP envelope around the response WSDL message
					wsdl_response = SOAPUtils.basicRemoveSoapEnvelopeDocument(wsdl_response);
				
				if (SOAPFactory.DEBUG) System.out.println("SOAP CLIENT STRIPPED TO (doc): "+wsdl_response);		
	
			}
	
			transport.close();
			
			return wsdl_response;
		
		} catch (Exception e) {
			throw new SOAPException("SOAP Client Transaction Failed",wsdl_message,wsdl_response,rpc_type,operationNamespace,operation,soapAction,e);
		}
	}
		
}