/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.transport;

import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip.TCPIPTransport;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class ReconnectTest {
	static SessionAddress address;
	
	public static void main(String[] args) throws Throwable {
		address = new SessionAddress("localhost",9000,9000,"localhost",9000,9000);
		address.setReconnectionFailureAbortTimeout(180000);
		address.setRequiresLinkReconnection(true);
		address.setRequiresMultipleConnections(false);
		address.setRequiresMultipleStreams(false);
		
		Server server = new Server();
		server.start();
		Thread.sleep(300);
		Client client = new Client();
		client.start();
		
		server.join();
		client.join();
		System.exit(0);
	}
	
	public static class Server extends Thread {
		public void run() {
			try {
				Session session = SessionFactory.newSession(address,false);
				session.begin();
				
				OutputStream out = session.getOutputStream((short)0);

				for (int i = 0; i < 10000000; i++) {
					out.write(i%100);
				}
				System.out.println("Server wrote OK");
				
			} catch (Throwable t) {
				t.printStackTrace();
			}
		}
	}
	public static class Client extends Thread {
		public void run() {
			try {
				Session session = SessionFactory.newSession(address,true);
				session.begin();
				
				InputStream in = session.getInputStream((short)0);
				
				for (int i = 0; i < 10000000; i++) {
					int n = in.read();
					
					if (i == 50000) {
						TCPIPTransport transport = (TCPIPTransport)session.transport;
						InputStream intercepted_in = transport.in;
System.out.println("Intercepted read");						
//						for (int k = 0; k < 978; k++) {
						for (int k = 0; k < 49000; k++) {
//							System.out.println("Intercepted read "+k);						
							intercepted_in.read();
						}
						System.out.println("Intercepted read finished");						
						session.transport.close();
					}
					
					if (n != i%100) {
						throw new Throwable("MISMATCH "+n+" != "+(i%100));
					}
					
//					out.write(i%100);
				}
				System.out.println("Client read OK");
				
			} catch (Throwable t) {
				t.printStackTrace();
			}
		}
	}
}