/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.transport.session;


/**
 * 
 * @author amiguel
 *
 * A thread used to begin a session and keep track of progress
 */
public class SessionBeginThread extends Thread {

	Session session;
	Exception error;
	
	public SessionBeginThread(Session session) {
		this.session = session;
	}
	
	public void run() {
		try {
			session.begin();
		} catch (Exception e) {
			error = e;
		}
	}
	
	public boolean connectedSuccessfully() {
		return error != null;
	}
	
	public Exception getConnectionError() {
		return error;
	}
}