/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;

import java.util.HashMap;

public class NamedNodeMap extends HashMap {

Element owner;

	public NamedNodeMap(Element owner) {
		super(16,0.6f);
		this.owner = owner;
	}
	
	public int getLength() {
		return size();
	} 
	public Node getNamedItem(String name) {
		Attr attr = new Attr(owner,name,(String)get(name));
		attr.setStartLine(owner.getStartLine());
		attr.setEndLine(owner.getEndLine());
		return attr;
	} 
	public Node getNamedItemNS(String namespaceURI, String localName) {
		Attr attr = new Attr(owner,localName,(String)get(localName));
		attr.setStartLine(owner.getStartLine());
		attr.setEndLine(owner.getEndLine());
		return attr;
	} 
	public Node item(int index) {
		String name = (String)keySet().toArray()[index];
		Attr attr = new Attr(owner,name,(String)get(name));
		attr.setStartLine(owner.getStartLine());
		attr.setEndLine(owner.getEndLine());
		return attr;
	} 
	public Node removeNamedItem(String name) {
		Attr attr = new Attr(owner,name,(String)get(name));
		attr.setStartLine(owner.getStartLine());
		attr.setEndLine(owner.getEndLine());
		remove(name);
		return attr;
	}
	public Node removeNamedItemNS(String namespaceURI, String localName) {
		return removeNamedItem(localName);
	}
	public Node setNamedItem(Node arg) {
		Attr attr = (Attr)arg;
		put(attr.getNodeName(),attr.getNodeValue());
		return arg;
	}
	public Node setNamedItemNS(Node arg) {
		return setNamedItem(arg);
	}

}