/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;

public abstract class Node {

	public static short 	ATTRIBUTE_NODE = 0;
	public static short 	CDATA_SECTION_NODE = 1;
	public static short 	COMMENT_NODE = 2;
	public static short 	DOCUMENT_FRAGMENT_NODE = 2;
	public static short 	DOCUMENT_NODE = 3;
	public static short 	DOCUMENT_TYPE_NODE = 4;
	public static short 	ELEMENT_NODE = 5;
	public static short 	ENTITY_NODE = 6;
	public static short 	ENTITY_REFERENCE_NODE = 7;
	public static short 	NOTATION_NODE = 8;
	public static short 	PROCESSING_INSTRUCTION_NODE = 9;
	public static short 	TEXT_NODE 	 = 10;

	private Document doc;

	public Node parent;
	public NodeList children = new NodeList();

//	public W3CNode(Document doc) {
//		this.doc = doc;
//	}

	int startLine = -1, endLine = -1, writtenLine = -1;
	String fileref;

	public void setFileRef(String fileref) {
		this.fileref = fileref;
	}
	
	public String getFileRef() {
		return fileref;
	}
	
	public int getEndLine() {
		return endLine;
	}

	public void setEndLine(int endLine) {
		this.endLine = endLine;
	}

	public int getStartLine() {
		return startLine;
	}

	public void setStartLine(int startLine) {
		this.startLine = startLine;
	}

	public void setWrittenLine(int line) {
		this.writtenLine = line;
	}
	
	public int getWrittenLine() {
		return writtenLine;
	}
	
	public Node(Node parent, int line) {
		if (parent != null) {
			doc = parent.getOwnerDocument();
		}
		this.parent = parent;
	}

	void setParent(Node parent) {
		this.doc = parent.getOwnerDocument();
		this.parent = parent;
	}

	public Node appendChild(Node newChild) {
//		newChild.doc = doc;
		children.add((Node)newChild);
		return newChild;
	}
	public Node cloneNode(boolean deep) {
		Node clone = cloneNode(parent);

		if (deep == false) {
			//no children cloning
			return clone;
		} else {
			for (int i = 0; i < children.size(); i++) {
				Node child = (Node)children.get(i);
				Node child_clone = (Node)child.cloneNode(true);
				child_clone.setParent(clone);
				clone.appendChild(child_clone);	
			}
			return clone;
		}
	} 
	abstract Node cloneNode(Node parent);
	public abstract NamedNodeMap getAttributes();
	
	public NodeList getChildNodes() {
		return children;
	} 
	public Node getFirstChild() {
		if (children.size() > 0) {
			return (Node)children.get(0); 
		} else {
			return null;	
		}
	} 
	public Node getLastChild() {
		if (children.size() > 0) {
			return (Node)children.get(children.size()-1); 
		} else {
			return null;	
		}
	} 
	public String getLocalName() {
		return null;
	} 
	public String getNamespaceURI() {
		return null;
	} 
	public Node getNextSibling() {
		if (parent == null) return null;
		NodeList list = (NodeList)parent.getChildNodes(); 
		int n = list.indexOf(this);
		if (n == -1) return null;
		if (list.size() > n) {
			return (Node)list.item(n+1);
		} else {
			return null;
		}
	} 
	public abstract String getNodeName();

	public abstract short getNodeType();

	public abstract String getNodeValue();

	public Document getOwnerDocument() {
		return doc;
	}
	public Node getParentNode() {
		return parent;
	} 
	public String getPrefix() {
		return null;
	} 
	public Node getPreviousSibling() {
		if (parent == null) return null;
		NodeList list = (NodeList)parent.getChildNodes(); 
		int n = list.indexOf(this);
		if (n <= 0) return null;
		return (Node)list.item(n-1);
	} 
	public abstract boolean hasAttributes();
	public boolean hasChildNodes() {
		return children.size() > 0;
	}
	public Node insertBefore(Node newChild, Node refChild) {
		if (refChild == null) {
			appendChild(newChild);
			return newChild;
		}
		
		int n = children.indexOf(refChild);
		if (n == -1) return null;

		children.add(n,newChild);
		return newChild;
	}
	public boolean isSupported(String feature, String version) {
		return false;
	}
	public void normalize() {
		//remove adjacent text nodes and empty text nodes
	}
	public Node removeChild(Node oldChild) {
		if (children.remove(oldChild)) {
			return oldChild;	
		} else {
			return null;
		}
	} 
	public Node replaceChild(Node newChild, Node oldChild) {
		int n = children.indexOf(oldChild);
		if (n != -1) {
			Node child = (Node)children.remove(n);
			children.add(n,newChild);
			return child;
		} else {
			return null;	
		}
	}  
	public abstract void setNodeValue(String nodeValue);
	public void setPrefix(String prefix) {
		//ignored
	}
	
	void filterList(NodeList list, int type_allow) {
		for (int i = 0; i < list.size(); i++) {
			Node node = (Node)list.get(i);
			if (node.getNodeType() != type_allow) {
				list.remove(i--);	
			} 	
		}	
	}

	void filterList(NodeList list, String name) {
		for (int i = 0; i < list.size(); i++) {
			Node node = (Node)list.get(i);
			if (!node.getNodeName().equals(name)) {
				list.remove(i--);	
			} 	
		}	
	}
	
	NodeList getDepthFirstList() {
		NodeList list = new NodeList();
		getDepthFirstList(list); 
		return list;
	}
	
	void getDepthFirstList(NodeList list) {
		list.add(this);
		for (int i = 0; i < children.size(); i++) {
			Node node = (Node)children.get(i);
			node.getDepthFirstList(list);
		}
	}
	
}