package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.actions.CreateActionBase;
import org.eclipse.stp.sc.jaxws.wizards.handler.NewHandlerCreationWizard;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateHandlerAction  extends CreateActionBase{
    private static LoggingProxy LOG = LoggingProxy.getlogger(CreateWebServiceAction.class);

    public CreateHandlerAction() {
        super();
        // TODO Auto-generated constructor stub
    }

    public void dispose() {
        // TODO Auto-generated method stub
    }

    public void init(IWorkbenchWindow window) {
        // TODO Auto-generated method stub
    }

    public void run(IAction action) {
        if (selection != null && !selection.isEmpty()) {
            try {
            	NewHandlerCreationWizard wizard = new NewHandlerCreationWizard();
            	wizard.init(PlatformUI.getWorkbench(), selection);
                
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                WizardDialog dialog = new WizardDialog(shell, wizard);
                dialog.open();
            } catch (Exception e) {
                LOG.debug("exception on handler wizard run", e);
            }
        }
    }
    
    public void selectionChanged(IAction action, ISelection sel) {
    	if (sel == null) {
            selection = null;
        } else if (sel instanceof IStructuredSelection) {
        	selection = (IStructuredSelection)sel;
        	Object selObj = selection.getFirstElement();
        	IProject project = getProject(selObj);
        	try{
            	if(project != null 
            			&& project.hasNature(ScNature.NATURE_ID)){
            		action.setEnabled(true);
            	}else{
            		action.setEnabled(false);
            	}
        	}catch (CoreException e){
        		LOG.error(e);
        	}

        }else{
        	action.setEnabled(false);
        }
    }
    
    private IProject getProject(Object obj){
    	IProject rtnValue = null;
    	if(obj != null){
    		if(obj instanceof IProject){
    			rtnValue = (IProject)obj;
    		}else if(obj instanceof IResource){
    			rtnValue = ((IResource)obj).getProject();
    		}else if(obj instanceof IJavaElement){
    			rtnValue = ((IJavaElement)obj).getJavaProject().getProject();
    		}
    	}
    	return rtnValue;
    }
    
    
}
