/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.builders;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.builders.ScJavaBuilder;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.generators.types.JaxBindTypeGenerator;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class ScJaxbBuilder extends ScJavaBuilder {
    
    public static final String BUILDER_ID = "org.eclipse.stp.sc.jaxws.builders.jaxbbuilder";
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJaxbBuilder.class);
    
    public ScJaxbBuilder() {
        super();
        LOG.debug("JAXB builder has been created");
    }
    
    /**
     * generate request / response wrapper class
     * @param javaFile, the java file with @WebService annotation
     */
    protected void buildOneJavaFile(IFile javaFile) throws CoreException {
        try {
            if (javaFile.getFileExtension() == null
                || !javaFile.getFileExtension().equals("java")) {
                return;
            }
            LOG.debug("build one file called in JaxBuilder");
            ICompilationUnit compUnit = JDTUtils.getJavaUnitFromFile(javaFile);

            if (JavaDocumentUtils.needToGenerateWrapper(compUnit)) {
                LOG.info("generate wrapper type classes for SEI:"
                         + compUnit.findPrimaryType().getFullyQualifiedName());

                JaxBindTypeGenerator typeGen = new JaxBindTypeGenerator();
                typeGen.createWrapperCls(compUnit);
            }
            
        } catch (Exception e) {
            LOG.debug("generation failure", e);

            Status status = new Status(IStatus.ERROR,
                ResourcesPlugin.PI_RESOURCES,
                IResourceStatus.BUILD_FAILED,
                e.getMessage(),
                e);
            throw new CoreException(status);
        }
    }
    
    protected void clean(IProgressMonitor monitor) throws CoreException {
        //do nothing duing clean for the wrapper builder. 
    }

	@Override
	protected boolean checkAnnotation(IFile javaFile) {
		return JavaDocumentUtils.hasWebServiceAnnotation(javaFile);
	}
	

	protected void removeResourceFile(IResource res) throws CoreException {
		if (!(res instanceof IFile)) {
			return;
		}

		IFile file = (IFile) res;

		if (!file.getFileExtension().equals("java")) {
			return;
		}

		if (checkAnnotation(file)) {
			LOG.debug("WebService java file has been removed:"
					+ file.getFullPath());

			String clsName = JDTUtils.getJavaClassNameFromFile(file);

			if (clsName.lastIndexOf(".") > 0) {
				clsName = clsName.substring(clsName.lastIndexOf("."));
			}

			String wsdlName = clsName + ".wsdl";
			LOG.debug("  need to remove:" + wsdlName);

			IContainer folder = JaxWsWorkspaceManager.getWSDLFolder(getProject());
			IResource wsdlResource = folder.findMember(wsdlName);

			if (wsdlResource.exists()) {
				LOG.debug("delete wsdl resource:" + wsdlResource.getFullPath());
				wsdlResource.delete(IResource.FORCE, null);
			}
		}
	}
}
