/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.internal.facet;

import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.J2EEVersionConstants;
import org.eclipse.jst.j2ee.project.facet.J2EEModuleFacetInstallDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JaxWsFacetInstallDataModelProvider extends
		J2EEModuleFacetInstallDataModelProvider {

	private static final String JAXWS_V2_0 = "2.0";

	private static final String JAXWS_PROJECT_FACET = "stp.jaxws.component";
	private static final String JAVA_SOURCE_FOLDER = "java.source.folder";

	public static final IProjectFacetVersion JAXWS_20 = ProjectFacetsManager
			.getProjectFacet(JAXWS_PROJECT_FACET).getVersion(JAXWS_V2_0); //$NON-NLS-1$

	@SuppressWarnings("unchecked")
	public Set getPropertyNames() {
		Set names = super.getPropertyNames();
		names.add(CONFIG_FOLDER);
		names.add(JAVA_SOURCE_FOLDER);
		return names;
	}

	public Object getDefaultProperty(String propertyName) {
		if (propertyName.equals(FACET_ID)) {
			return JAXWS_PROJECT_FACET;
		} else if (propertyName.equals(CONFIG_FOLDER)) {
			return "wsdl";
		} else if (propertyName
				.equals(JAVA_SOURCE_FOLDER)) {
			return "src";
		}
		return super.getDefaultProperty(propertyName);
	}

	
	protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
		return J2EEVersionConstants.J2EE_1_4_ID;
	}

	public boolean isPropertyEnabled(String propertyName) {
		return super.isPropertyEnabled(propertyName);
	}

	public boolean propertySet(String propertyName, Object propertyValue) {
		boolean status = false;
		status = super.propertySet(propertyName, propertyValue);
		return status;
	}

	public IStatus validate(String propertyName) {
		return OK_STATUS;
	}
	

}
