/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.annotations.webservice;

import javax.jws.WebService;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.annotations.AnnotationAttributePage;
import org.eclipse.stp.sc.jaxws.wizards.annotations.CreateAnnotationWizard;


public class CreateWebServiceWizard extends CreateAnnotationWizard {
    // page identifiers used by this wizard
    public static final String ATTRIBUTE_PAGE = "attributePage";
    AnnotationAttributePage serviceAttributePage;

    public CreateWebServiceWizard(IMember aMember) {
        super(aMember);

        String title = ScJaxWsResources.getString("CreateWebServiceWizard.Title");
        setWindowTitle(title);
        
        ANNOTATION_REQUIRED.put(WebService.class, true);
    }

    @Override
    public void addPages() {
        super.addPages();
        serviceAttributePage = new AnnotationAttributePage(this,
                                                           null,
                                                           null,
                                                           WebService.class,
                                                           ANNOTATION_REQUIRED.get(WebService.class));
        addPage(serviceAttributePage);
    }

    @Override
    public boolean performFinish() {
        return super.performFinish();
    }

    @SuppressWarnings("unchecked")
    protected boolean updateAST(CompilationUnit astRoot, ASTRewrite astRewrite) {
        return addAnnotationToTypeMember(astRoot,
                                         astRewrite,
                                         (IType)getJavaMemberFromData(),
                                         WebService.class,
                                         ANNOTATION_REQUIRED.get(WebService.class));
    }
}
