/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.wsdltojava;

import java.util.Hashtable;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.wizards.AbstractScWizard;
import org.eclipse.stp.sc.common.wizards.AbstractScWizardPage;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;



public class GeneralInfoPage extends AbstractScWizardPage {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(GeneralInfoPage.class);

    protected IProject project;
    protected Combo cboOutputDir;
    protected Hashtable<String, IPath> possibleNewPaths = new Hashtable<String, IPath>();
    protected IParameterPage paramPage;
    
    private static ImageDescriptor defaultImgDesc =
        ScJaxWsResources.getImageDescriptor("wizban/wsdl_to_java_wiz.gif");

    public GeneralInfoPage(AbstractScWizard aParentWizard, String pageName, String aHelpContextId) {
        super(aParentWizard, pageName, aHelpContextId);

        setTitle(ScJaxWsResources.getString("WsdlToJava.GeneralInfoPage.Title"));
        setDescription(ScJaxWsResources.getString("WsdlToJava.GeneralInfoPage.Description"));
        setImageDescriptor(defaultImgDesc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, SWT.NONE);
        container.setLayout(new GridLayout(1, false));
        
        Group grpParams = new Group(container, SWT.NONE);
        grpParams.setLayoutData(new GridData(GridData.FILL_BOTH));
        grpParams.setLayout(new GridLayout(1, false));
        grpParams.setText(ScJaxWsResources.getString("Wsdl.To.Java.Gen.Param.Title"));
        
    	project = (IProject)parentWizard.getWizardData().get(GenerateCodeWizard.DATA_PROJECT);
        RuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
        
        String runtimeType = RuntimeCore.getRuntimeType(project);
        
        paramPage = rtMgr.getParameterPage(runtimeType);
        paramPage.createContents(grpParams);
        paramPage.setPage(this);

        Group grpOutputDir = new Group(container, SWT.NONE);
        grpOutputDir.setText(ScJaxWsResources.getString(
                "WsdlToJava.GeneralInfoPage.OutputDir.Label"));

        grpOutputDir.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        grpOutputDir.setLayout(new GridLayout(1, false));
        
        cboOutputDir = new Combo(grpOutputDir, SWT.READ_ONLY | SWT.DROP_DOWN);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = GridData.FILL;
        cboOutputDir.setLayoutData(gridData);
        populateOutputDirCombo();
        

        setControl(container);
    }

    @SuppressWarnings("unchecked")
    @Override
    public void applyToData(Map<String, Object> data) throws Exception {
    	paramPage.performOK();
        String projectRootLoc = project.getWorkspace().getRoot().getRawLocation().toOSString();
        LOG.debug("the output code gen location: " + projectRootLoc);
        
        Hashtable<String, Object> genParams = 
            (Hashtable<String, Object>)data.get(GenerateCodeWizard.DATA_GEN_PARAMS);
        
        genParams.put(IWsdlToJavaGenerator.TOOL_SPECIFIC_OPS, paramPage.getParameters());
        
        // apply currently selected params
        String strOutputDir = projectRootLoc + getOutputDir();
        ((Hashtable<String, Object>)genParams).put(IWsdlToJavaGenerator.GEN_OUTPUTDIR, strOutputDir);
        
        IPath newPath = possibleNewPaths.get(getOutputDir());
        if (newPath != null) {
        	data.put(GenerateCodeWizard.DATA_NEW_BUILD_PATH, new IPath[]{newPath});
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void initializeFromData(Map data) throws Exception {
        project = (IProject)data.get(GenerateCodeWizard.DATA_PROJECT);
        populateOutputDirCombo();

        // TODO Auto-generated method stub
    }

    /**
     * @return
     * @see org.eclipse.stp.sc.common.wizards.AbstractScWizardPage#validateInputs()
     */
    protected boolean validateInputs() {
        setErrorMessage(null);
        setMessage(null);
        
        String errMsg = paramPage.validateParams();
        if (errMsg != null) {
            setErrorMessage(paramPage.validateParams());
            return false;
        }
        return true;
    }

    public String getOutputDir() {
        return cboOutputDir.getText();
    }

    private void populateOutputDirCombo() {
        if (project == null) {
            return;
        }
        
        cboOutputDir.removeAll();
        possibleNewPaths.clear();
        
        IPath[] srcPaths = ScJDTUtils.getProjectSrcPaths(project);

        for (int i = 0; i < srcPaths.length; i++) {
        	if (!possibleNewPaths.containsKey(srcPaths[i].toOSString())) {
                cboOutputDir.add(srcPaths[i].toOSString());
        	}
        }

        if (cboOutputDir.getItemCount() > 0) {
            cboOutputDir.select(0);
        }
    }
}
