/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;

/**
 * A default implementation of IScribblerDomain. Clients are required to
 * implement
 * {@link org.eclipse.stp.core.infrastructure.emf.IScribblerDomain#getEditModelLabel()}
 * and
 * {@link org.eclipse.stp.core.infrastructure.emf.IScribblerDomain#getResourceDescriptors()}.
 * 
 * <p>
 * Clients are permitted to subclass this implementation directly.
 * </p>
 */
public abstract class DefaultScribblerDomain implements IScribblerDomain {

   private final Map                    lifecycles = new HashMap();

   private ITechnologyFlavorLifecycle[] NO_LIFECYCLES;

   public boolean isContained(IResourceDescriptor aResourceDescriptor) {
      IResourceDescriptor[] descriptors = getResourceDescriptors();
      IPath filePath = aResourceDescriptor.getLocalPath();
      for (int i = 0; i < descriptors.length; i++) {
         if (descriptors[i].getLocalPath().equals(filePath))
            return true;
      }
      return false;
   }

   public boolean isContained(Resource aResource) {
      IFile file = WorkbenchResourceHelper.getFile(aResource);
      IResourceDescriptor[] descriptors = getResourceDescriptors();
      if (file != null) {
         IPath filePath = file.getFullPath();
         for (int i = 0; i < descriptors.length; i++) {
            if (descriptors[i].getLocalPath().equals(filePath))
               return true;
         }
      }
      return false;
   }

   public void addTechnologyFlavorLifecycle(
         ITechnologyFlavorLifecycle flavorManager) {
      lifecycles.put(flavorManager.getId(), flavorManager);

   }

   public ITechnologyFlavorLifecycle getTechnologyFlavorLifecycle(
         String technologyFlavorId) {
      return (ITechnologyFlavorLifecycle) lifecycles.get(technologyFlavorId);
   }

   public ITechnologyFlavorLifecycle[] getTechnologyFlavorLifecycles() {

      if (lifecycles.size() == 0)
         return NO_LIFECYCLES;
      return (ITechnologyFlavorLifecycle[]) lifecycles.values().toArray(
            new ITechnologyFlavorLifecycle[lifecycles.size()]);
   }

   public boolean matches(IUndoContext context) {
      if (context instanceof IScribblerDomain) {
         IScribblerDomain otherDomain = (IScribblerDomain) context;
         return Arrays.equals(getResourceDescriptors(), otherDomain
               .getResourceDescriptors());
      }
      return false;
   }

   public String getLabel() {
      return getEditModelLabel();
   }

}
