/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

/**
 * 
 * The IEMFWorkbenchContext is the foundation of the EMF Resource Management
 * Framework. The context will listen for events from any Resource Set that it
 * is connected to ({@link org.eclipse.stp.core.infrastructure.emf.IResourceAssistant#getManagedResourceSets()}).
 * These events are then funnelled into the IEditModels that are managed by the
 * IEMFWorkbenchContext.
 * 
 * <p>
 * Even though the IEMFWorkbenchContext is the manager of all IEditModels for a
 * given project, clients should rely on
 * {@link org.eclipse.stp.core.infrastructure.emf.IEditModelFactory} to acquire
 * IEditModels.
 * </p>
 * 
 * <p>
 * The IEMFWorkbenchContext exposes opportunities to integrate extra logic into
 * the EMF infrastructure. In general, these methods should not be required, but
 * for integrating with other EMF frameworks, they are sometimes necessary.
 * </p>
 * 
 * <p>
 * Clients should <b><i>NEVER</i></b> resort to casting this interface to its
 * underlying implementation to access methods exposed on the <b>internal</b>
 * implementation. Instead, clients should request that methods be exposed as
 * API and demonstrate the need for exposing the requested methods.
 * </p>
 */
public interface IEMFWorkbenchContext {

   /**
    * The IResourceAssistant will be consulted whenever a resource is requested.
    * The IResourceAssistent should be conservative when deciding which
    * resources it would like to load (in place of the resource that would be
    * loaded in the ProjectResourceSet used by the IEMFWorkbenchContext).
    * 
    * org.eclipse.jem.util.emfworkbench plugin
    * 
    * @param anAssistant
    */
   void installResourceAssistant(IResourceAssistant anAssistant);

   void uninstallResourceHandler(IResourceAssistant anAssistant);
}
