/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class EMFInfrastructurePlugin extends Plugin {

   private static EMFInfrastructurePlugin instance;

   /**
    * The plugin id.
    * 
    */
   public static String                   PLUGIN_ID = "org.eclipse.stp.core.infrastructure.emf"; //$NON-NLS-1$

   public EMFInfrastructurePlugin() {
      super();
      instance = this;
   }

   public static void logError(int aCode, String aMessage, Throwable anException) {
      instance.getLog().log(createErrorStatus(aCode, aMessage, anException));
   }

   public static void log(int severity, int aCode, String aMessage,
         Throwable exception) {
      log(createStatus(severity, aCode, aMessage, exception));
   }

   public static void log(IStatus aStatus) {
      instance.getLog().log(aStatus);
   }

   public static IStatus createStatus(int severity, int aCode, String aMessage,
         Throwable exception) {
      return new Status(severity, PLUGIN_ID, aCode, aMessage, exception);
   }

   public static IStatus createErrorStatus(int aCode, String aMessage,
         Throwable exception) {
      return createStatus(IStatus.ERROR, aCode, aMessage, exception);
   }
}
