/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.actions;

import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.operations.ExecuteDeploymentJob;
import org.eclipse.swt.widgets.Shell;

/**
 * @author rcernich
 * 
 * Created on Jan 21, 2005
 */
public class ExecuteDeployAction extends BaseAction {

	private Shell mShell;

	/**
	 * @param text
	 */
	public ExecuteDeployAction(String text, Shell shell) {
		super(text);
		mShell = shell;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		// Make sure any dirty files are saved.
		if (!DeployCorePlugin.getDefault().getWorkbench()
				.saveAllEditors(true)) {
			return;
		}
		
		ExecuteDeploymentJob deployOp = new ExecuteDeploymentJob(
				getSelectedRoot(), mShell);

		deployOp.schedule();
	}
	
	 
}