/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import java.io.File;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;


/**
 * @author rcernich
 * 
 * Created on Jul 21, 2004
 */
public class PackageCreationContext implements IPackageCreationContext {

	private IServer mTarget;
	private File mOutputFolder;
	private File mTempFolder;
	private OverwriteCancelQuery mOverwriteCancelQuery;

	public PackageCreationContext(IServer target, File outputFolder,
									File tempFolder) {
		this(target, outputFolder, tempFolder, new OverwriteCancelQuery());
	}

	public PackageCreationContext(IServer target, File outputFolder,
									File tempFolder,
									OverwriteCancelQuery overwriteCancelQuery) {
		super();
		mTarget = target;
		mOutputFolder = outputFolder;
		mTempFolder = tempFolder;
		mOverwriteCancelQuery = overwriteCancelQuery;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IPackageCreationContext#getTarget()
	 */
	public IServer getTarget() {
		return mTarget;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IPackageCreationContext#getOutputFolder()
	 */
	public File getOutputFolder() {
		return mOutputFolder;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IPackageCreationContext#getTempFolder()
	 */
	public File getTempFolder() {
		return mTempFolder;
	}

	public int promptForOverwrite(String fileName) {
		return mOverwriteCancelQuery.promptForOverwrite(fileName);
	}

	public static class OverwriteCancelQuery {

		private static String[] sButtonLabels = new String[] {
				IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL,
				IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL,
				IDialogConstants.CANCEL_LABEL};
		private static int[] sResultIds = new int[] { IDialogConstants.YES_ID,
				IDialogConstants.YES_TO_ALL_ID, IDialogConstants.NO_ID,
				IDialogConstants.NO_TO_ALL_ID, IDialogConstants.CANCEL_ID};

		private boolean mYesToAll = false;
		private boolean mNoToAll = false;

		public OverwriteCancelQuery() {
			super();
		}

		int promptForOverwrite(final String fileName) {
			if (mYesToAll) {
				return OVERWRITE;
			}
			if (mNoToAll) {
				return USE_EXISTING;
			}

			Display display = PlatformUI.getWorkbench().getDisplay();
			final int result[] = new int[1];

			display.syncExec(new Runnable() {

				public void run() {
					boolean disposeShell = false;
					Display display = Display.getCurrent();
					Shell shell = display.getActiveShell();
					if (shell == null) {
						Shell shells[] = display.getShells();
						if (shells.length > 0) {
							shell = shells[shells.length - 1];
						}
						else {
							disposeShell = true;
							shell = new Shell();
						}
					}
					try {
						MessageDialog dialog = new MessageDialog(shell,
								DeployCorePlugin.getDefault().getResourceString("OverwritePackageDialog.TITLE"), null, DeployCorePlugin.getDefault().getResourceString("OverwritePackageDialog.MESSAGE", new String[] {fileName}),
								MessageDialog.QUESTION, sButtonLabels, 0);
						result[0] = dialog.open();
					}
					finally {
						if (disposeShell) {
							shell.dispose();
						}
					}
				}
			});
			switch (sResultIds[result[0]]) {
			case IDialogConstants.YES_TO_ALL_ID:
				mYesToAll = true;
			case IDialogConstants.YES_ID:
				return OVERWRITE;
			case IDialogConstants.NO_TO_ALL_ID:
				mNoToAll = true;
			case IDialogConstants.NO_ID:
				return USE_EXISTING;
			case IDialogConstants.CANCEL_ID:
				return CANCEL;
			default:
				// We'll get an array index out of bounds error before we
				// get here.
				return OVERWRITE;
			}
		}
	}

}