/*******************************************************************************
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

/**
 * 
 * Factory class to create web module, which can be deployed to wtp server
 * 
 * @author jma
 */
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;

public class WTPServiceModuleFactory extends ModuleFactoryDelegate {

	
	public static String FACET_PROJECT_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
	public static String MODULE_TYPE = "jst.web";
    public static String MODULE_VERSION = "2.2";
    
    private final static String FOLDER_EXT = "Deploy";
	
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WTPServiceModuleFactory.class);
    
	protected Map<IModule, ModuleDelegate> moduleDelegates = new HashMap<IModule, ModuleDelegate>(5);
	
	public WTPServiceModuleFactory() {
		super();
	}
	
	@Override
	public ModuleDelegate getModuleDelegate(IModule module) {
        return moduleDelegates.get(module);
	}

	@Override
	public IModule[] getModules() {
		//get all module for the workspace?
		return null;
	}

	/**
	 * add facet nature to the project
	 * @param project
	 * @throws Exception
	 */
	private void addFacetNature(IProject project) throws  Exception {
		IProjectDescription projDesc = project.getDescription();
		String[] natures = projDesc.getNatureIds();
		String[] newNatures = new String[natures.length + 1];
		System.arraycopy(natures, 0, newNatures, 0, natures.length);
		newNatures[newNatures.length - 1] = FACET_PROJECT_NATURE;
		projDesc.setNatureIds(newNatures);
		project.setDescription(projDesc, null);
	}
	
	public IModule createModule(IProject project, IPackageOutputDescriptor desc) {
		String id = desc.getLogicalName();
		 
		try {
			
			//add faced nature
			if (!project.hasNature(FACET_PROJECT_NATURE)) {
				addFacetNature(project);
			}
			IProjectFacet pf = ProjectFacetsManager.getProjectFacet(MODULE_TYPE);
			IProjectFacetVersion fv = pf.getVersion(MODULE_VERSION);

			IFacetedProject facetedProject = ProjectFacetsManager.create(project);
			
			//add jst.web faced
			if (!facetedProject.hasProjectFacet(pf))  {
				LOG.debug("install jst.web facet");
			    facetedProject.installProjectFacet(fv, null, null);
			}
		} catch (Exception e) {
			e.printStackTrace();
			LOG.error(e);
		}
		
		//need to change here. do not create moduledelegate this way. should get from somewhere.
		/*
		if (name.endsWith(".war")) {
			String docBase = name.substring(0, name.indexOf(".war"));
			docBase = docBase + "/" + name;
			name = docBase;
		}
		*/
		
		String name = getModuleName(desc);
		
		LOG.debug("Module id:" + id);
		LOG.debug("Module name:" + name);
		
	    IModule module = createStpModule(id, name, MODULE_TYPE, MODULE_VERSION, project);
	    
	    
	    ServiceModuleDelegate moduleDelegate = new ServiceModuleDelegate(
	    		project, desc);
	    moduleDelegate.setModule(module);
	    moduleDelegates.put(module, moduleDelegate);
	    //call the validate, 
	    ((Module)module).validate(null);
	    return module;
	}
	
	public String getModuleName(IPackageOutputDescriptor desc){
		String name=desc.getLogicalName();
		if (name.endsWith(".war")) {
			name = name.substring(0, name.indexOf(".war"));
			
		}
		//name = name + FOLDER_EXT;	 
		
		return name;
	}
	
	/**
	 * over the createModule method to create stp module
	 * Sicne the creaetModule in super class is final, we use another name for override
	 * the factory attribute is private in super class, which is invisiable to us. Thus
	 * we use ServerPlugin.findModuleFactory to lookup the factory again 
	 */
	
	protected IModule createStpModule(String id, String name, String type, String version, IProject project) {
		String factorId = getId();
		ModuleFactory factory = ServerPlugin.findModuleFactory(factorId);
		return new StpModule(factory, id, name, type, version, project);
	}
	

}
