package org.eclipse.stp.sc.xmlvalidator.preferences;

import java.util.Collection;
import java.util.LinkedList;

import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.stp.sc.xmlvalidator.XmlValidatorResources;
import org.eclipse.stp.sc.xmlvalidator.rule.engine.VRuleManager;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleDef;
import org.eclipse.swt.SWT;
//import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RuleTableEditor {
	
	Table table;
	LinkedList<TableEditor> editorList;
	
	
	static String[] severity = {
		XmlValidatorResources.getString("marker.severity.info"),
		XmlValidatorResources.getString("marker.severity.warning"),
		XmlValidatorResources.getString("marker.severity.error"),
	};
	
	public RuleTableEditor() {
	    editorList = new LinkedList<TableEditor>();	
	}

	
	public void resetTable() {
		for (TableEditor editor : editorList) {
		    Control old = editor.getEditor();
		    if (old != null) {
		    	old.dispose();
		    }
		}
		editorList.clear();
		table.removeAll();
	}
	
	public Composite createContents(Composite parent) {
		table = new Table(parent, SWT.BORDER | SWT.SINGLE);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		TableColumn enableColumn = new TableColumn(table, SWT.CENTER);
		//enableColumn.setText(XmlValidatorResources.getString("preference.ruletable.enabled"));
		enableColumn.setText("");
		enableColumn.pack();
		
		
		TableColumn idColumn = new TableColumn(table, SWT.LEFT);
		idColumn.setText(XmlValidatorResources.getString("preference.ruletable.ruleid"));
		idColumn.pack();
		
		TableColumn sColumn = new TableColumn(table, SWT.LEFT);
		sColumn.setText(XmlValidatorResources.getString("preference.ruletable.severity"));
		sColumn.pack();
		
		TableColumn conColumn = new TableColumn(table, SWT.LEFT);
		conColumn.setText(XmlValidatorResources.getString("preference.ruletable.context"));
		conColumn.pack();
		
		TableColumn descColumn = new TableColumn(table, SWT.LEFT);
		descColumn.setText(XmlValidatorResources.getString("preference.ruletable.desc"));
		descColumn.pack();
		
		TableLayout layout = new TableLayout();
		layout.addColumnData(new ColumnWeightData(10, 20, true));
		layout.addColumnData(new ColumnWeightData(20, 40, true));
		layout.addColumnData(new ColumnWeightData(25, 20, true));
		layout.addColumnData(new ColumnWeightData(40, 30, true));
		layout.addColumnData(new ColumnWeightData(70, 30, true));
		table.setLayout(layout);
		
		return table;
	}
	
	public void setRules(Collection<VRuleDef> rules) {
		table.removeAll();
		for (VRuleDef rule : rules) {
			setRuleDef(rule);
		}
	}
		
	public void setRuleDef(VRuleDef rule) {
		//enable button
		TableItem item = new TableItem(table, SWT.NONE);
		TableEditor btnEditor = new TableEditor(table);
		editorList.add(btnEditor);
		Button enableBtn = new Button(table, SWT.CHECK);
		enableBtn.setBackground(item.getBackground());
		//Set attributes of the button
		enableBtn.computeSize(SWT.DEFAULT, table.getItemHeight());

		enableBtn.setSelection(rule.getEnabled());
		enableBtn.addSelectionListener(new EnableSelectionAdapter(rule.getId()));


		// Set attributes of the editor
		btnEditor.grabHorizontal = true;
		btnEditor.minimumHeight = enableBtn.getSize().y;
		btnEditor.minimumWidth = enableBtn.getSize().x;

		// Set the editor for the first column in the row
		btnEditor.setEditor(enableBtn, item, 0);
		
		//ruleID
		item.setText(1, rule.getId());
		//severity
		item.setText(2, severity[0]);
		
		//context
		item.setText(3, rule.getContextNode());
		
		//description
		item.setText(4, rule.getDescription());
		
		
	    TableEditor sEditor = new TableEditor(table);
	    editorList.add(sEditor);
	    sEditor.horizontalAlignment = SWT.LEFT;
	    sEditor.grabHorizontal = true;

	    //severity combo
//	    CCombo combo = new CCombo(table, SWT.READ_ONLY);
	    Combo combo = new Combo(table, SWT.READ_ONLY);
	    combo.setBackground(item.getBackground());
        for (int i = 0, n = severity.length; i < n; i++) {
          combo.add(severity[i]);
        }
        if (rule.getSeverity() == VRuleDef.SEVERITY.ERROR) {
        	combo.setText(severity[2]);
        } else if (rule.getSeverity() == VRuleDef.SEVERITY.INFO) {
        	combo.setText(severity[0]);
        } else {
        	combo.setText(severity[1]);
        }

        //Select the previously selected item from the cell
        combo.select(combo.getItemCount() -1);
        combo.computeSize(SWT.DEFAULT, table.getItemHeight());
        combo.addSelectionListener(new SeveritySelectionAdapter(rule.getId(), 
        		combo));
	    
        sEditor.grabHorizontal = true;
        sEditor.minimumHeight = combo.getSize().y;
        sEditor.minimumWidth = combo.getSize().x;

        sEditor.setEditor(combo, item, 2);
        
	}
	
	
}

class SeveritySelectionAdapter extends SelectionAdapter {
	Combo cmbSeverity = null;
	String ruleID;
	public SeveritySelectionAdapter(String id, Combo cmb) {
		cmbSeverity = cmb;
		ruleID = id;
	}
	
	public void widgetSelected(SelectionEvent e) {
		VRuleManager.getInstance().setRuleSeverity(ruleID, cmbSeverity.getText());
	}
}


class EnableSelectionAdapter extends SelectionAdapter {
	String ruleID;
	public EnableSelectionAdapter(String ruleid) {
		ruleID = ruleid;
	}
	public void widgetSelected(SelectionEvent e) {
		Button btnEnable = (Button)e.widget;
		VRuleManager.getInstance().setRuleEnabled(ruleID, 
				btnEnable.getSelection());
    }
}