/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 * 
 * Part of the generic runtime engine API, used to help implement BPEL synchronization links.
 */
public class BPELLink {

	private static final String PREFIX = "BPL:";
	
	public static boolean incoming(RunnerInterface runner, String name) throws Exception {
		Message m = runner.receiveMessage(PREFIX+name);
		return m.getType() == 1;
	}
	
	public static void outgoing(RunnerInterface runner, String name, boolean status) throws Exception {
		int i = 0;
		if (status) i = 1;
		Message m = new Message(i);
		runner.sendMessage(PREFIX+name,m);
	}
}