/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.util.HashMap;

/**
 * 
 * @author amiguel
 *
 * An interface which classes using HTTPServer must implement to receive requests
 */
public interface HTTPServerListener {
	
	/**
	 * Process and HTTP server request and return a response
	 * 
	 * @param port the TCP port that this request came in on
	 * @param resource the resource that was requested by this HTTP request
	 * @param payload any (and all) content (non-header data) that came in with this HTTP request
	 * @param lc_headers map of lowercase header name to header data (e.g. 'content-length' -> '2345')
	 * @return the content of the HTTP response
	 * @throws HTTPException if there was an error processing this request, or HTTPNotFoundException if this is the wrong processor for this request
	 */
	public String doRequest(int port, String resource, String payload, HashMap lc_headers) throws HTTPException;
}