/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.multiplex;

import java.util.Random;

import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;

/**
 * @author amiguel
 * 
 * A class to test the ByteArrayIn/Out buffers
 */
public class ByteArrayOutBufferTest {
	
static long start = System.currentTimeMillis();
	
	public static void main(String[] args) {
		ByteArrayOutBuffer bout = new ByteArrayOutBuffer();
		ByteArrayInBuffer bain = new ByteArrayInBuffer();
		new WriterThread(bout).start();
		new ReaderThread(bout,bain).start();
	}
	
	public static class WriterThread extends Thread {
		ByteArrayOutBuffer stream;
		public WriterThread(ByteArrayOutBuffer b) {
			stream = b;
		}
		public void run() {
			Random rand = new Random(start);
			try {
				while (true) {
					
					int choice = rand.nextInt(2);
					if (choice == 0) {
						StreamUtils.writeInt(stream,rand.nextInt());
					} else if (choice == 1) {
						StreamUtils.writeBytes(stream,new byte[rand.nextInt(30000)]);
					} else if (choice == 2) {
						StreamUtils.writeString(stream,new String(""+rand.nextInt()+""+rand.nextDouble()+""+rand.nextGaussian()+""+rand.nextLong()));
					}

					try {
						Thread.sleep(2);
					} catch (Exception e) {
					}
					
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.exit(0);
			}
		}
	}
	public static class ReaderThread extends Thread {
		ByteArrayOutBuffer baut;
		ByteArrayInBuffer bain;
		public ReaderThread(ByteArrayOutBuffer bout, ByteArrayInBuffer bin) {
			baut = bout;
			bain = bin;
		}
		public void run() {
			Exception exc = new Exception("out of sync");
			
			ByteArrayInBuffer bain = new ByteArrayInBuffer();
			
			Random rand = new Random(start);
			try {
				long t = System.currentTimeMillis();
				long total = 0;
				
				while (true) {
					byte[] dat = baut.clearToByteArray(2000);
					total += dat.length;
					bain.add(dat);

					if (bain.length() > 30000) {
						int choice = rand.nextInt(2);
						if (choice == 0) {
							if (rand.nextInt() != StreamUtils.readInt(bain)) {
								throw exc;
							}
						} else if (choice == 1) {
							if (rand.nextInt(30000) != StreamUtils.readBytes(bain).length) {
								throw exc;
							}
						} else if (choice == 2) {
							if (!new String(""+rand.nextInt()+""+rand.nextDouble()+""+rand.nextGaussian()+""+rand.nextLong()).equals(StreamUtils.readString(bain))) {
								throw exc;
							}
						}
					}

//					try {
//						Thread.sleep(2);
//					} catch (Exception e) {
//					}

					if (System.currentTimeMillis() > t) {
						System.out.println(total+" bytes transferred ("+baut.size()+" bytes in OUT buffer) ("+bain.length()+" bytes in IN buffer)");
						t = System.currentTimeMillis() + 2000;
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.exit(0);
			}
		}
	}
}