/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

/**
 * 
 * @author amiguel
 *
 * A fast stack implementation with certain features required for the XPATH 
 * expression implementation code
 */
public class FStack {

//should be big enough to deal with most expressions, growing costs us
Object[] stack = new Object[40];

int ptr = 0;

	public FStack() {
	}
	
	public int size() {
		return ptr;
	}
	
	public Object get(int i) {
		return stack[i];
	}
	
	public void clear() {
		ptr = 0;
	}
	
	public Object peek() {
		return stack[ptr-1];
	}

	public Object peek(int n) {
		return stack[ptr-n];
	}

	public Object pop() {
		return stack[--ptr];
	}

	public void discard(int n) {
		ptr-=n;
	}
	
	public void discardAndPush(int discard, Object push) {
		discard(discard);
		push(push);
	}
	
	public void push(Object o) {
		stack[ptr++] = o;
		if (ptr == stack.length) {
			Object[] tmp = new Object[stack.length*3];
			System.arraycopy(stack,0,tmp,0,stack.length);
			stack = tmp;
		}
	}
	
	public void discardAndPush(int discard, boolean b) {
		discardAndPush(discard,new Boolean(b));
	}
	public void push(boolean b) {
		push(new Boolean(b));
	}
	public void discardAndPush(int discard, double d) {
		discardAndPush(discard,new Double(d));
	}
	public void push(double d) {
		push(new Double(d));
	}
	
	public static void main(String[] args) {
		FStack stack = new FStack();
		stack.push(1);
		stack.push(true);
		stack.push(new Double(2));
		stack.push(new Double(3));

		if (!stack.peek(2).equals(new Double(2))) {
			System.out.println("ERROR: stack.peek(2) is wrong - returned "+stack.peek(2));
		}
		if (!stack.peek().equals(new Double(3))) {
			System.out.println("ERROR: stack.peek() is wrong - returned "+stack.peek());
		}
		if (!stack.pop().equals(new Double(3))) {
			System.out.println("ERROR: stack.pop() is wrong");
		}
		if (!stack.pop().equals(new Double(2))) {
			System.out.println("ERROR: stack.pop() is wrong");
		}
	}
}