/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.util.LinkedList;

/**
 * @author amiguel
 * 
 * Object pool
 * creates a pool of integers from 0 - N
 * provides unique IDs from the pool
 * if no more than X clients ever hold an ID at any time then the pool will never be more than
 * X in size and the range of the IDs will be 0 - X
 */
public class ObjectPool {
	Class type;
	
	Object uobj_LOCK = new Object();
	LinkedList uobj_queue = new LinkedList();
	int uid_next = 0;

	public ObjectPool(Class type) throws InstantiationException, IllegalAccessException {
		this(type,1);
	}

	public ObjectPool(Class type, int siz) throws InstantiationException, IllegalAccessException {
		this.type = type;
		
		if (siz <= 0) siz = 1;
		
		for (int i = 0; i < siz; i++) {
			//add a uid to the pool
			uobj_queue.add(type.newInstance());
		}
	}

	public Object getObject() {
		Object uobj;
		synchronized(uobj_LOCK) {
			if (uobj_queue.size() == 0) {
				//no objects left - add another to the pool
				try {
					uobj_queue.add(type.newInstance());
				} catch (Exception x) {
					throw new Error(x.toString());
				}
			}
			uobj = uobj_queue.removeFirst();
		}
		return uobj;
	}
	public void releaseObject(Object instance) {
		synchronized(uobj_LOCK) {
			uobj_queue.add(instance);
		}
	}
}